/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.managers;

import com.mongenscave.mcchatgame.identifiers.GameState;
import com.mongenscave.mcchatgame.identifiers.GameType;
import com.mongenscave.mcchatgame.models.GameHandler;
import com.mongenscave.mcchatgame.models.impl.GameCrafting;
import com.mongenscave.mcchatgame.models.impl.GameFillOut;
import com.mongenscave.mcchatgame.models.impl.GameMath;
import com.mongenscave.mcchatgame.models.impl.GameRandomCharacters;
import com.mongenscave.mcchatgame.models.impl.GameReverse;
import com.mongenscave.mcchatgame.models.impl.GameWhoAmI;
import com.mongenscave.mcchatgame.models.impl.GameWordGuess;
import com.mongenscave.mcchatgame.models.impl.GameWordStop;
import java.util.EnumMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class GameManager {
    private static final Map<GameType, GameHandler> ACTIVE_GAMES = new EnumMap<GameType, GameHandler>(GameType.class);
    private static long lastGameEndTime = 0L;

    public static void startGame(@NotNull GameType type) {
        if (ACTIVE_GAMES.containsKey((Object)type)) {
            return;
        }
        GameHandler handler = switch (type) {
            default -> throw new MatchException(null, null);
            case GameType.MATH -> new GameMath();
            case GameType.WHO_AM_I -> new GameWhoAmI();
            case GameType.WORD_GUESSER -> new GameWordGuess();
            case GameType.RANDOM_CHARACTERS -> new GameRandomCharacters();
            case GameType.WORD_STOP -> new GameWordStop();
            case GameType.REVERSE -> new GameReverse();
            case GameType.FILL_OUT -> new GameFillOut();
            case GameType.CRAFTING -> new GameCrafting();
        };
        handler.start();
        ACTIVE_GAMES.put(type, handler);
    }

    public static void handleAnswer(@NotNull Player player, @NotNull String answer) {
        ACTIVE_GAMES.values().forEach(handler -> {
            if (handler.getState() == GameState.ACTIVE) {
                handler.handleAnswer(player, answer);
            }
        });
    }

    public static int getActiveGameCount() {
        return (int)ACTIVE_GAMES.values().stream().filter(handler -> handler.getState() == GameState.ACTIVE).count();
    }

    public static void removeInactiveGames() {
        for (Map.Entry<GameType, GameHandler> entry2 : ACTIVE_GAMES.entrySet()) {
            if (entry2.getValue().getState() != GameState.INACTIVE) continue;
            lastGameEndTime = System.currentTimeMillis();
            break;
        }
        ACTIVE_GAMES.entrySet().removeIf(entry -> ((GameHandler)entry.getValue()).getState() == GameState.INACTIVE);
    }

    @Generated
    public static long getLastGameEndTime() {
        return lastGameEndTime;
    }
}

