/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.models.impl;

import com.mongenscave.mcchatgame.McChatGame;
import com.mongenscave.mcchatgame.identifiers.GameState;
import com.mongenscave.mcchatgame.identifiers.keys.ConfigKeys;
import com.mongenscave.mcchatgame.identifiers.keys.MessageKeys;
import com.mongenscave.mcchatgame.models.GameHandler;
import com.mongenscave.mcchatgame.processor.AutoGameProcessor;
import com.mongenscave.mcchatgame.services.MainThreadExecutorService;
import com.mongenscave.mcchatgame.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.mongenscave.mcchatgame.utils.GameUtils;
import com.mongenscave.mcchatgame.utils.PlayerUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class GameReverse
extends GameHandler {
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    private MyScheduledTask timeoutTask;
    private String originalWord;
    private long startTime;

    @Override
    public void start() {
        if (this.state == GameState.ACTIVE) {
            return;
        }
        List<String> words = ConfigKeys.REVERSE_WORDS.getList();
        if (words.isEmpty()) {
            return;
        }
        GameUtils.playSoundToEveryone(ConfigKeys.SOUND_START_ENABLED, ConfigKeys.SOUND_START_SOUND);
        this.originalWord = words.get(this.random.nextInt(words.size())).trim();
        String reversed = new StringBuilder(this.originalWord).reverse().toString();
        this.gameData = reversed;
        this.startTime = System.currentTimeMillis();
        this.setAsActive();
        this.announceReversed(reversed);
        this.scheduleTimeout();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void stop() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.cleanup();
        AutoGameProcessor gameProcessor = McChatGame.getInstance().getGameProcessor();
        gameProcessor.start();
    }

    @Override
    public void handleAnswer(@NotNull Player player, @NotNull String answer) {
        if (this.state != GameState.ACTIVE) {
            return;
        }
        if (answer.trim().equalsIgnoreCase(this.originalWord)) {
            long endTime = System.currentTimeMillis();
            double timeTaken = (double)(endTime - this.startTime) / 1000.0;
            String formattedTime = String.format("%.2f", timeTaken);
            ((CompletableFuture)McChatGame.getInstance().getDatabase().incrementWin(player).thenCompose(v -> McChatGame.getInstance().getDatabase().setTime(player, timeTaken))).thenAcceptAsync(v -> {
                GameUtils.rewardPlayer(player);
                GameUtils.broadcast(MessageKeys.REVERSE_WIN.getMessage().replace("{player}", player.getName()).replace("{time}", formattedTime));
                this.handlePlayerWin(player);
                this.cleanup();
            }, MainThreadExecutorService.getInstance().getMainThreadExecutor());
            PlayerUtils.sendToast(player, ConfigKeys.TOAST_MESSAGE, ConfigKeys.TOAST_MATERIAL, ConfigKeys.TOAST_ENABLED);
            GameUtils.playSoundToWinner(player, ConfigKeys.SOUND_WIN_ENABLED, ConfigKeys.SOUND_WIN_SOUND);
        }
    }

    private void announceReversed(@NotNull String reversed) {
        GameUtils.broadcastMessages(MessageKeys.REVERSE, "{word}", reversed);
    }

    private void scheduleTimeout() {
        this.timeoutTask = McChatGame.getInstance().getScheduler().runTaskLater(() -> {
            if (this.state == GameState.ACTIVE) {
                GameUtils.broadcast(MessageKeys.REVERSE_NO_WIN.getMessage());
                this.handleGameTimeout();
                this.cleanup();
            }
        }, (long)ConfigKeys.REVERSE_TIME.getInt() * 20L);
    }
}

