/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mongenscave.mcchatgame.McChatGame;
import com.mongenscave.mcchatgame.identifiers.keys.ConfigKeys;
import com.mongenscave.mcchatgame.utils.LoggerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class PlayerUtils {
    private static final McChatGame plugin = McChatGame.getInstance();
    private static final ConcurrentHashMap<UUID, NamespacedKey> toastAdvancements = new ConcurrentHashMap();
    private static final Gson gson = new Gson();

    public static void sendToast(@NotNull Player player, @NotNull ConfigKeys title, @NotNull ConfigKeys icon, @NotNull ConfigKeys enabled) {
        if (!enabled.getBoolean()) {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)plugin, "toast_" + String.valueOf(player.getUniqueId()) + "_" + System.currentTimeMillis());
        try {
            PlayerUtils.createAndRegisterAdvancement(key, title.getString(), Material.valueOf((String)icon.getString()));
            plugin.getScheduler().runTaskLater(() -> PlayerUtils.grantAdvancement(player, key), 1L);
            plugin.getScheduler().runTaskLater(() -> PlayerUtils.removeAdvancement(player, key), 100L);
        }
        catch (Exception exception) {
            LoggerUtils.error(exception.getMessage(), new Object[0]);
        }
    }

    private static void createAndRegisterAdvancement(NamespacedKey key, String title, Material icon) {
        try {
            JsonObject advancement = PlayerUtils.createAdvancementJson(title, icon);
            Bukkit.getUnsafe().loadAdvancement(key, advancement.toString());
        }
        catch (Exception exception) {
            LoggerUtils.error(exception.getMessage(), new Object[0]);
        }
    }

    private static void grantAdvancement(@NotNull Player player, NamespacedKey key) {
        try {
            Advancement advancement = Bukkit.getAdvancement((NamespacedKey)key);
            if (advancement != null) {
                AdvancementProgress progress = player.getAdvancementProgress(advancement);
                if (!progress.isDone()) {
                    for (String criteria : progress.getRemainingCriteria()) {
                        progress.awardCriteria(criteria);
                    }
                }
                toastAdvancements.put(player.getUniqueId(), key);
            }
        }
        catch (Exception exception) {
            LoggerUtils.error(exception.getMessage(), new Object[0]);
        }
    }

    public static void removeAdvancement(@NotNull Player player, NamespacedKey key) {
        try {
            Advancement advancement = Bukkit.getAdvancement((NamespacedKey)key);
            if (advancement != null) {
                AdvancementProgress progress = player.getAdvancementProgress(advancement);
                for (String criteria : advancement.getCriteria()) {
                    progress.revokeCriteria(criteria);
                }
            }
            toastAdvancements.remove(player.getUniqueId());
            try {
                Bukkit.getUnsafe().removeAdvancement(key);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            LoggerUtils.error(exception.getMessage(), new Object[0]);
        }
    }

    @NotNull
    private static JsonObject createAdvancementJson(String title, @NotNull Material icon) {
        String jsonString = String.format("{\n    \"display\": {\n        \"icon\": {\n            \"id\": \"%s\"\n        },\n        \"title\": {\n            \"text\": \"%s\"\n        },\n        \"description\": {\n            \"text\": \"%s\"\n        },\n        \"background\": \"minecraft:textures/gui/advancements/backgrounds/adventure.png\",\n        \"frame\": \"task\",\n        \"announce_to_chat\": false,\n        \"show_toast\": true,\n        \"hidden\": true\n    },\n    \"criteria\": {\n        \"trigger\": {\n            \"trigger\": \"minecraft:impossible\"\n        }\n    }\n}", icon.getKey(), PlayerUtils.escapeJson(title), PlayerUtils.escapeJson(""));
        return (JsonObject)gson.fromJson(jsonString, JsonObject.class);
    }

    @NotNull
    private static String escapeJson(@NotNull String text) {
        return text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public static void cleanup() {
        for (Map.Entry<UUID, NamespacedKey> entry : toastAdvancements.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            PlayerUtils.removeAdvancement(player, entry.getValue());
        }
        toastAdvancements.clear();
    }

    @Generated
    private PlayerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

