/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.zapper.repository;

import com.mongenscave.mcchatgame.zapper.Dependency;
import com.mongenscave.mcchatgame.zapper.repository.MavenRepository;
import java.io.File;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public interface Repository {
    @NotNull
    public URL resolve(@NotNull Dependency var1) throws Exception;

    @NotNull
    public static Repository maven(@NotNull URL url) {
        return MavenRepository.maven(url.toString());
    }

    @NotNull
    public static Repository maven(@NotNull String url) {
        return MavenRepository.maven(url);
    }

    @NotNull
    public static Repository mavenLocal() {
        String userHome = System.getProperty("user.home");
        File repository = new File(userHome, ".m2" + File.separator + "repository");
        return Repository.maven(repository);
    }

    @NotNull
    public static Repository maven(@NotNull File directory) {
        return Repository.maven(directory.toURI().toURL().toString());
    }

    @NotNull
    public static Repository mavenCentral() {
        return MavenRepository.mavenCentral();
    }

    @NotNull
    public static Repository jitpack() {
        return MavenRepository.jitpack();
    }

    @NotNull
    public static Repository paper() {
        return MavenRepository.paper();
    }

    @NotNull
    public static Repository minecraft() {
        return MavenRepository.minecraft();
    }
}

