/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame;

import com.mongenscave.mcchatgame.boostedyaml.settings.dumper.DumperSettings;
import com.mongenscave.mcchatgame.boostedyaml.settings.general.GeneralSettings;
import com.mongenscave.mcchatgame.boostedyaml.settings.loader.LoaderSettings;
import com.mongenscave.mcchatgame.boostedyaml.settings.updater.UpdaterSettings;
import com.mongenscave.mcchatgame.bstats.bukkit.Metrics;
import com.mongenscave.mcchatgame.config.Config;
import com.mongenscave.mcchatgame.database.Database;
import com.mongenscave.mcchatgame.database.impl.H2;
import com.mongenscave.mcchatgame.database.impl.MySQL;
import com.mongenscave.mcchatgame.hooks.plugins.PlaceholderAPI;
import com.mongenscave.mcchatgame.listener.GameListener;
import com.mongenscave.mcchatgame.processor.AutoGameProcessor;
import com.mongenscave.mcchatgame.services.MainThreadExecutorService;
import com.mongenscave.mcchatgame.universalScheduler.UniversalScheduler;
import com.mongenscave.mcchatgame.universalScheduler.scheduling.schedulers.TaskScheduler;
import com.mongenscave.mcchatgame.update.UpdateChecker;
import com.mongenscave.mcchatgame.utils.LoggerUtils;
import com.mongenscave.mcchatgame.utils.PlayerUtils;
import com.mongenscave.mcchatgame.utils.RegisterUtils;
import com.mongenscave.mcchatgame.zapper.ZapperJavaPlugin;
import java.io.File;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class McChatGame
extends ZapperJavaPlugin {
    static McChatGame instance;
    TaskScheduler scheduler;
    Config language;
    Database database;
    Executor mainThreadExecutor;
    AutoGameProcessor gameProcessor;
    UpdateChecker updateChecker;
    Config config;

    public void onLoad() {
        instance = this;
        this.scheduler = UniversalScheduler.getScheduler((Plugin)this);
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.initializeComponents();
        this.initializeDatabase();
        MainThreadExecutorService.initialize();
        this.getServer().getPluginManager().registerEvents((Listener)new GameListener(), (Plugin)this);
        this.gameProcessor = new AutoGameProcessor();
        this.gameProcessor.start();
        PlaceholderAPI.registerHook();
        RegisterUtils.registerCommands();
        new Metrics((JavaPlugin)this, 26553);
        this.updateChecker = new UpdateChecker(8147);
        LoggerUtils.printStartup();
    }

    public void onDisable() {
        if (this.database != null) {
            this.database.shutdown();
        }
        if (this.gameProcessor != null) {
            this.gameProcessor.stop();
        }
        PlayerUtils.cleanup();
    }

    public Config getConfiguration() {
        return this.config;
    }

    private void initializeComponents() {
        GeneralSettings generalSettings = GeneralSettings.builder().setUseDefaults(false).build();
        LoaderSettings loaderSettings = LoaderSettings.builder().setAutoUpdate(true).build();
        UpdaterSettings updaterSettings = UpdaterSettings.builder().setKeepAll(true).build();
        this.config = this.loadConfig("config.yml", generalSettings, loaderSettings, updaterSettings);
        this.language = this.loadConfig("messages.yml", generalSettings, loaderSettings, updaterSettings);
    }

    @NotNull
    @Contract(value="_, _, _, _ -> new")
    private Config loadConfig(@NotNull String fileName, @NotNull GeneralSettings generalSettings, @NotNull LoaderSettings loaderSettings, @NotNull UpdaterSettings updaterSettings) {
        return new Config(new File(this.getDataFolder(), fileName), this.getResource(fileName), generalSettings, loaderSettings, DumperSettings.DEFAULT, updaterSettings);
    }

    private void initializeDatabase() {
        String databaseType;
        switch (databaseType = this.config.getString("database.type", "h2").toLowerCase()) {
            case "mysql": {
                String host = this.config.getString("database.mysql.host");
                int port = this.config.getInt("database.mysql.port");
                String databaseName = this.config.getString("database.mysql.database");
                String username = this.config.getString("database.mysql.username");
                String password = this.config.getString("database.mysql.password");
                this.database = new MySQL(host, port, databaseName, username, password);
                break;
            }
            case "h2": {
                this.database = new H2();
                break;
            }
            default: {
                LoggerUtils.error("Unsupported database type: " + databaseType, new Object[0]);
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        try {
            this.database.initialize().join();
            LoggerUtils.info("Database initialized successfully", new Object[0]);
        }
        catch (Exception exception) {
            LoggerUtils.error("Failed to initialize database: " + exception.getMessage(), new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    @Generated
    public static McChatGame getInstance() {
        return instance;
    }

    @Generated
    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    @Generated
    public Config getLanguage() {
        return this.language;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public Executor getMainThreadExecutor() {
        return this.mainThreadExecutor;
    }

    @Generated
    public AutoGameProcessor getGameProcessor() {
        return this.gameProcessor;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }
}

