/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.models;

import com.mongenscave.mcchatgame.identifiers.GameState;
import com.mongenscave.mcchatgame.managers.GameManager;
import com.mongenscave.mcchatgame.managers.StreakManager;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GameHandler {
    protected GameState state = GameState.INACTIVE;
    protected Object gameData;
    protected boolean gameStarted = false;
    private static GameHandler currentActiveGame = null;

    public abstract void start();

    public abstract void stop();

    public abstract void handleAnswer(@NotNull Player var1, @NotNull String var2);

    protected void cleanup() {
        this.state = GameState.INACTIVE;
        this.gameData = null;
        this.gameStarted = false;
        if (currentActiveGame == this) {
            currentActiveGame = null;
        }
        GameManager.removeInactiveGames();
    }

    protected void setAsActive() {
        currentActiveGame = this;
        this.state = GameState.ACTIVE;
        if (!this.gameStarted) {
            StreakManager.getInstance().onGameStart();
            this.gameStarted = true;
        }
    }

    protected void handlePlayerWin(@NotNull Player winner) {
        StreakManager.getInstance().onPlayerWin(winner);
    }

    protected void handleGameTimeout() {
        StreakManager.getInstance().onGameTimeout();
    }

    @Nullable
    public static GameHandler getCurrentActiveGame() {
        return currentActiveGame;
    }

    @Nullable
    public String getGameData() {
        return this.gameData != null ? this.gameData.toString() : null;
    }

    public abstract long getStartTime();

    @Generated
    public GameState getState() {
        return this.state;
    }
}

