/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.models.impl;

import com.mongenscave.mcchatgame.McChatGame;
import com.mongenscave.mcchatgame.boostedyaml.block.implementation.Section;
import com.mongenscave.mcchatgame.identifiers.GameState;
import com.mongenscave.mcchatgame.identifiers.keys.ConfigKeys;
import com.mongenscave.mcchatgame.identifiers.keys.MessageKeys;
import com.mongenscave.mcchatgame.models.GameHandler;
import com.mongenscave.mcchatgame.processor.AutoGameProcessor;
import com.mongenscave.mcchatgame.processor.MessageProcessor;
import com.mongenscave.mcchatgame.services.MainThreadExecutorService;
import com.mongenscave.mcchatgame.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.mongenscave.mcchatgame.utils.GameUtils;
import com.mongenscave.mcchatgame.utils.LoggerUtils;
import com.mongenscave.mcchatgame.utils.PlayerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import net.coma112.easiermessages.EasierMessages;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameCrafting
extends GameHandler
implements Listener {
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    private final AtomicBoolean winnerDetermined = new AtomicBoolean(false);
    private MyScheduledTask timeoutTask;
    private String targetItem;
    private List<String> requiredItems;
    private long startTime;
    private final Set<UUID> participatingPlayers = Collections.synchronizedSet(new HashSet());
    private final ConcurrentHashMap<UUID, Inventory> playerInventories = new ConcurrentHashMap();

    @Override
    public void start() {
        if (this.state == GameState.ACTIVE) {
            return;
        }
        Section craftsSection = ConfigKeys.CRAFTING_CRAFTS.getSection();
        if (craftsSection == null || craftsSection.getRoutesAsStrings(false).isEmpty()) {
            return;
        }
        ConcurrentHashMap crafts = new ConcurrentHashMap();
        for (String key : craftsSection.getRoutesAsStrings(false)) {
            Section craftSection = craftsSection.getSection(key);
            if (craftSection == null) continue;
            ConcurrentHashMap<String, List> craftData = new ConcurrentHashMap<String, List>();
            craftData.put("items-to-place", craftSection.getStringList("items-to-place"));
            crafts.put(key, craftData);
        }
        GameUtils.playSoundToEveryone(ConfigKeys.SOUND_START_ENABLED, ConfigKeys.SOUND_START_SOUND);
        ArrayList craftKeys = new ArrayList(crafts.keySet());
        this.targetItem = (String)craftKeys.get(this.random.nextInt(craftKeys.size()));
        ConcurrentHashMap craftData = (ConcurrentHashMap)crafts.get(this.targetItem);
        List itemsToPlace = (List)craftData.get("items-to-place");
        this.requiredItems = new ArrayList<String>(itemsToPlace);
        this.gameData = this.targetItem;
        this.startTime = System.currentTimeMillis();
        this.winnerDetermined.set(false);
        this.setAsActive();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)McChatGame.getInstance());
        this.announceCrafting();
        this.scheduleTimeout();
    }

    @Override
    public void stop() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        for (UUID playerId : this.participatingPlayers) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player == null || !player.isOnline()) continue;
            player.closeInventory();
        }
        HandlerList.unregisterAll((Listener)this);
        this.cleanup();
        AutoGameProcessor gameProcessor = McChatGame.getInstance().getGameProcessor();
        gameProcessor.start();
    }

    @Override
    public void handleAnswer(@NotNull Player player, @NotNull String answer) {
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    protected void cleanup() {
        this.winnerDetermined.set(false);
        super.cleanup();
    }

    public void openCraftingMenu(@NotNull Player player) {
        if (this.state != GameState.ACTIVE) {
            return;
        }
        this.participatingPlayers.add(player.getUniqueId());
        Inventory craftingInv = Bukkit.createInventory(null, (InventoryType)InventoryType.WORKBENCH, (String)MessageProcessor.process(ConfigKeys.CRAFTING_TITLE.getString().replace("{item}", this.targetItem)));
        ArrayList<String> shuffledItems = new ArrayList<String>(this.requiredItems);
        Collections.shuffle(shuffledItems);
        for (int i = 0; i < Math.min(shuffledItems.size(), 9); ++i) {
            try {
                Material material = Material.valueOf((String)((String)shuffledItems.get(i)));
                ItemStack item = new ItemStack(material, 1);
                craftingInv.setItem(i + 1, item);
                continue;
            }
            catch (IllegalArgumentException exception) {
                LoggerUtils.error(exception.getMessage(), new Object[0]);
            }
        }
        this.playerInventories.put(player.getUniqueId(), craftingInv);
        player.openInventory(craftingInv);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.state != GameState.ACTIVE) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.participatingPlayers.contains(player.getUniqueId())) {
            return;
        }
        Inventory clickedInv = event.getClickedInventory();
        Inventory topInv = event.getView().getTopInventory();
        if (!this.playerInventories.containsValue(topInv)) {
            return;
        }
        if (clickedInv != topInv) {
            event.setCancelled(true);
            return;
        }
        InventoryAction action = event.getAction();
        if (action == InventoryAction.MOVE_TO_OTHER_INVENTORY || action == InventoryAction.COLLECT_TO_CURSOR || action == InventoryAction.HOTBAR_MOVE_AND_READD || action == InventoryAction.HOTBAR_SWAP || action == InventoryAction.CLONE_STACK) {
            event.setCancelled(true);
            return;
        }
        if (event.getSlot() == 0) {
            ItemStack resultItem = event.getCurrentItem();
            if (resultItem != null && resultItem.getType().toString().equals(this.targetItem) && this.state == GameState.ACTIVE && this.winnerDetermined.compareAndSet(false, true)) {
                this.handleWin(player);
            }
            event.setCancelled(true);
            return;
        }
        if (event.getSlot() >= 1 && event.getSlot() <= 9) {
            if (event.isShiftClick()) {
                event.setCancelled(true);
                return;
            }
            McChatGame.getInstance().getScheduler().runTaskLater(() -> {
                if (this.state == GameState.ACTIVE && !this.winnerDetermined.get()) {
                    this.updateCraftingResult(topInv);
                }
            }, 1L);
        } else {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (this.state != GameState.ACTIVE) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.participatingPlayers.contains(player.getUniqueId())) {
            return;
        }
        Inventory topInv = event.getView().getTopInventory();
        if (!this.playerInventories.containsValue(topInv)) {
            return;
        }
        Set dragSlots = event.getRawSlots();
        boolean affectsInvalidSlots = dragSlots.stream().anyMatch(slot -> slot < 1 || slot > 9 || slot >= topInv.getSize());
        if (affectsInvalidSlots) {
            event.setCancelled(true);
            return;
        }
        McChatGame.getInstance().getScheduler().runTaskLater(() -> {
            if (this.state == GameState.ACTIVE && !this.winnerDetermined.get()) {
                this.updateCraftingResult(topInv);
            }
        }, 1L);
    }

    @EventHandler
    public void onInventoryClose(@NotNull InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.participatingPlayers.contains(player.getUniqueId())) {
            return;
        }
        Inventory craftingInv = this.playerInventories.get(player.getUniqueId());
        if (craftingInv != null) {
            for (int i = 0; i < craftingInv.getSize(); ++i) {
                craftingInv.setItem(i, null);
            }
        }
        this.participatingPlayers.remove(player.getUniqueId());
        this.playerInventories.remove(player.getUniqueId());
    }

    private void handleWin(@NotNull Player player) {
        long endTime = System.currentTimeMillis();
        double timeTaken = (double)(endTime - this.startTime) / 1000.0;
        String formattedTime = String.format("%.2f", timeTaken);
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        player.closeInventory();
        ((CompletableFuture)McChatGame.getInstance().getDatabase().incrementWin(player).thenCompose(v -> McChatGame.getInstance().getDatabase().setTime(player, timeTaken))).thenAcceptAsync(v -> {
            GameUtils.rewardPlayer(player);
            GameUtils.broadcast(MessageKeys.CRAFTING_WIN.getMessage().replace("{time}", formattedTime).replace("{player}", player.getName()));
            this.handlePlayerWin(player);
            this.cleanup();
        }, MainThreadExecutorService.getInstance().getMainThreadExecutor());
        PlayerUtils.sendToast(player, ConfigKeys.TOAST_MESSAGE, ConfigKeys.TOAST_MATERIAL, ConfigKeys.TOAST_ENABLED);
        GameUtils.playSoundToWinner(player, ConfigKeys.SOUND_WIN_ENABLED, ConfigKeys.SOUND_WIN_SOUND);
    }

    private void scheduleTimeout() {
        this.timeoutTask = McChatGame.getInstance().getScheduler().runTaskLater(() -> {
            if (this.state == GameState.ACTIVE && this.winnerDetermined.compareAndSet(false, true)) {
                GameUtils.broadcast(MessageKeys.CRAFTING_NO_WIN.getMessage());
                this.handleGameTimeout();
                this.cleanup();
            }
        }, (long)ConfigKeys.CRAFTING_TIME.getInt() * 20L);
    }

    private void updateCraftingResult(@NotNull Inventory inventory) {
        if (this.state != GameState.ACTIVE || this.winnerDetermined.get()) {
            return;
        }
        ItemStack[] matrix = new ItemStack[9];
        for (int i = 1; i <= 9; ++i) {
            matrix[i - 1] = inventory.getItem(i);
        }
        try {
            Material targetMaterial = Material.valueOf((String)this.targetItem);
            for (Recipe recipe : Bukkit.getRecipesFor((ItemStack)new ItemStack(targetMaterial))) {
                ShapelessRecipe shapelessRecipe;
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    if (!this.matchesShapedRecipe(matrix, shapedRecipe)) continue;
                    inventory.setItem(0, new ItemStack(targetMaterial, 1));
                    return;
                }
                if (!(recipe instanceof ShapelessRecipe) || !this.matchesShapelessRecipe(matrix, shapelessRecipe = (ShapelessRecipe)recipe)) continue;
                inventory.setItem(0, new ItemStack(targetMaterial, 1));
                return;
            }
        }
        catch (IllegalArgumentException exception) {
            LoggerUtils.error(exception.getMessage(), new Object[0]);
        }
        inventory.setItem(0, null);
    }

    private boolean matchesShapedRecipe(ItemStack[] matrix, @NotNull ShapedRecipe recipe) {
        String[] shape = recipe.getShape();
        Map ingredients = recipe.getIngredientMap();
        for (int offsetRow = 0; offsetRow <= 3 - shape.length; ++offsetRow) {
            for (int offsetCol = 0; offsetCol <= 3 - shape[0].length(); ++offsetCol) {
                if (!this.matchesAtPosition(matrix, shape, ingredients, offsetRow, offsetCol)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesAtPosition(ItemStack[] matrix, @NotNull String[] shape, Map<Character, ItemStack> ingredients, int offsetRow, int offsetCol) {
        for (int row = 0; row < shape.length; ++row) {
            for (int col = 0; col < shape[row].length(); ++col) {
                char c = shape[row].charAt(col);
                int matrixIndex = (row + offsetRow) * 3 + (col + offsetCol);
                ItemStack required = ingredients.get(Character.valueOf(c));
                ItemStack actual = matrix[matrixIndex];
                if (c != ' ') continue;
                if (actual != null && actual.getType() != Material.AIR) {
                    return false;
                }
                if (this.itemsMatch(actual, required)) continue;
                return false;
            }
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack item;
            boolean isInShape;
            int row = i / 3;
            int col = i % 3;
            boolean bl = isInShape = row >= offsetRow && row < offsetRow + shape.length && col >= offsetCol && col < offsetCol + shape[0].length();
            if (isInShape || (item = matrix[i]) == null || item.getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    private boolean matchesShapelessRecipe(@NotNull ItemStack[] matrix, @NotNull ShapelessRecipe recipe) {
        ArrayList required = new ArrayList(recipe.getIngredientList());
        ArrayList<ItemStack> provided = new ArrayList<ItemStack>();
        for (ItemStack item : matrix) {
            if (item == null || item.getType() == Material.AIR) continue;
            provided.add(item.clone());
        }
        if (required.size() != provided.size()) {
            return false;
        }
        for (ItemStack req : required) {
            boolean found = false;
            for (int i = 0; i < provided.size(); ++i) {
                if (!this.itemsMatch((ItemStack)provided.get(i), req)) continue;
                provided.remove(i);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return provided.isEmpty();
    }

    private boolean itemsMatch(@Nullable ItemStack actual, @Nullable ItemStack required) {
        if (actual == null && required == null) {
            return true;
        }
        if (actual == null || required == null) {
            return false;
        }
        return actual.getType() == required.getType();
    }

    private void announceCrafting() {
        for (String lines : MessageKeys.CRAFTING.getMessages()) {
            Component component = EasierMessages.translateMessage((String)lines.replace("{item}", this.targetItem)).build();
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage(component);
            }
        }
    }
}

