/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.models.impl;

import com.mongenscave.mcchatgame.McChatGame;
import com.mongenscave.mcchatgame.identifiers.GameState;
import com.mongenscave.mcchatgame.identifiers.keys.ConfigKeys;
import com.mongenscave.mcchatgame.identifiers.keys.MessageKeys;
import com.mongenscave.mcchatgame.models.GameHandler;
import com.mongenscave.mcchatgame.processor.AutoGameProcessor;
import com.mongenscave.mcchatgame.services.MainThreadExecutorService;
import com.mongenscave.mcchatgame.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.mongenscave.mcchatgame.utils.GameUtils;
import com.mongenscave.mcchatgame.utils.PlayerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class GameFillOut
extends GameHandler {
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    private final AtomicBoolean winnerDetermined = new AtomicBoolean(false);
    private MyScheduledTask timeoutTask;
    private String correctAnswer;
    private long startTime;

    @Override
    public void start() {
        if (this.state == GameState.ACTIVE) {
            return;
        }
        List<String> words = ConfigKeys.FILL_OUT_WORDS.getList();
        if (words.isEmpty()) {
            return;
        }
        GameUtils.playSoundToEveryone(ConfigKeys.SOUND_START_ENABLED, ConfigKeys.SOUND_START_SOUND);
        String originalWord = words.get(this.random.nextInt(words.size())).trim();
        String filled = this.generateFillOut(originalWord);
        this.correctAnswer = originalWord;
        this.gameData = filled;
        this.startTime = System.currentTimeMillis();
        this.winnerDetermined.set(false);
        this.setAsActive();
        this.announceFillOut(filled);
        this.scheduleTimeout();
    }

    @Override
    public void stop() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.cleanup();
        AutoGameProcessor gameProcessor = McChatGame.getInstance().getGameProcessor();
        gameProcessor.start();
    }

    @Override
    public void handleAnswer(@NotNull Player player, @NotNull String answer) {
        if (this.state != GameState.ACTIVE || !this.winnerDetermined.compareAndSet(false, true)) {
            return;
        }
        if (answer.trim().equalsIgnoreCase(this.correctAnswer)) {
            long endTime = System.currentTimeMillis();
            double timeTaken = (double)(endTime - this.startTime) / 1000.0;
            String formattedTime = String.format("%.2f", timeTaken);
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel();
            }
            ((CompletableFuture)McChatGame.getInstance().getDatabase().incrementWin(player).thenCompose(v -> McChatGame.getInstance().getDatabase().setTime(player, timeTaken))).thenAcceptAsync(v -> {
                GameUtils.rewardPlayer(player);
                GameUtils.broadcast(MessageKeys.FILL_OUT_WIN.getMessage().replace("{player}", player.getName()).replace("{time}", formattedTime));
                this.handlePlayerWin(player);
                this.cleanup();
            }, MainThreadExecutorService.getInstance().getMainThreadExecutor());
            PlayerUtils.sendToast(player, ConfigKeys.TOAST_MESSAGE, ConfigKeys.TOAST_MATERIAL, ConfigKeys.TOAST_ENABLED);
            GameUtils.playSoundToWinner(player, ConfigKeys.SOUND_WIN_ENABLED, ConfigKeys.SOUND_WIN_SOUND);
        }
        this.winnerDetermined.set(false);
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    protected void cleanup() {
        this.winnerDetermined.set(false);
        super.cleanup();
    }

    @NotNull
    @Contract(value="_ -> new")
    private String generateFillOut(@NotNull String word) {
        int length = word.length();
        int replaceCount = Math.max(1, (int)Math.ceil((double)length / 2.0));
        List<Integer> indices = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < length; ++i) {
            indices.add(i);
        }
        Collections.shuffle(indices);
        indices = indices.subList(0, replaceCount);
        char[] chars = word.toCharArray();
        Iterator iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            chars[index] = 95;
        }
        return new String(chars);
    }

    private void announceFillOut(@NotNull String filled) {
        GameUtils.broadcastMessages(MessageKeys.FILL_OUT, "{word}", filled);
    }

    private void scheduleTimeout() {
        this.timeoutTask = McChatGame.getInstance().getScheduler().runTaskLater(() -> {
            if (this.state == GameState.ACTIVE && this.winnerDetermined.compareAndSet(false, true)) {
                GameUtils.broadcast(MessageKeys.FILL_OUT_NO_WIN.getMessage().replace("{answer}", this.correctAnswer));
                this.handleGameTimeout();
                this.cleanup();
            }
        }, (long)ConfigKeys.FILL_OUT_TIME.getInt() * 20L);
    }
}

