/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.models.impl;

import com.mongenscave.mcchatgame.McChatGame;
import com.mongenscave.mcchatgame.boostedyaml.block.implementation.Section;
import com.mongenscave.mcchatgame.identifiers.GameState;
import com.mongenscave.mcchatgame.identifiers.keys.ConfigKeys;
import com.mongenscave.mcchatgame.identifiers.keys.MessageKeys;
import com.mongenscave.mcchatgame.models.GameHandler;
import com.mongenscave.mcchatgame.processor.AutoGameProcessor;
import com.mongenscave.mcchatgame.processor.MessageProcessor;
import com.mongenscave.mcchatgame.services.MainThreadExecutorService;
import com.mongenscave.mcchatgame.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.mongenscave.mcchatgame.utils.GameUtils;
import com.mongenscave.mcchatgame.utils.PlayerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class GameHangman
extends GameHandler {
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    private MyScheduledTask timeoutTask;
    private String correctWord;
    private Set<Character> guessedLetters;
    private Set<Player> playersWhoGuessed;
    private int wrongGuesses;
    private long startTime;
    private boolean gameWon = false;

    @Override
    public void start() {
        if (this.state == GameState.ACTIVE) {
            return;
        }
        List<String> words = ConfigKeys.HANGMAN_WORDS.getList();
        if (words.isEmpty()) {
            return;
        }
        this.correctWord = words.get(this.random.nextInt(words.size())).toUpperCase();
        this.guessedLetters = Collections.synchronizedSet(new HashSet());
        this.playersWhoGuessed = Collections.synchronizedSet(new HashSet());
        this.wrongGuesses = 0;
        this.startTime = System.currentTimeMillis();
        this.gameWon = false;
        this.gameData = this.buildDisplayWord();
        this.setAsActive();
        GameUtils.playSoundToEveryone(ConfigKeys.SOUND_START_ENABLED, ConfigKeys.SOUND_START_SOUND);
        this.announceGame();
        this.scheduleTimeout();
    }

    @Override
    public void stop() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.cleanup();
        AutoGameProcessor gameProcessor = McChatGame.getInstance().getGameProcessor();
        gameProcessor.start();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void handleAnswer(@NotNull Player player, @NotNull String answer) {
        if (this.state != GameState.ACTIVE || this.gameWon) {
            return;
        }
        if (answer.length() != 1) {
            return;
        }
        char letter = answer.toUpperCase().charAt(0);
        if (!Character.isLetter(letter)) {
            return;
        }
        if (ConfigKeys.HANGMAN_ONLY_ONCE.getBoolean() && this.playersWhoGuessed.contains(player)) {
            return;
        }
        if (this.guessedLetters.contains(Character.valueOf(letter))) {
            return;
        }
        this.guessedLetters.add(Character.valueOf(letter));
        this.playersWhoGuessed.add(player);
        if (this.correctWord.contains(String.valueOf(letter))) {
            this.gameData = this.buildDisplayWord();
            this.announceGame();
            if (this.isWordComplete()) {
                this.gameWon = true;
                long endTime = System.currentTimeMillis();
                double timeTaken = (double)(endTime - this.startTime) / 1000.0;
                String formattedTime = String.format("%.2f", timeTaken);
                if (this.timeoutTask != null) {
                    this.timeoutTask.cancel();
                }
                ((CompletableFuture)McChatGame.getInstance().getDatabase().incrementWin(player).thenCompose(v -> McChatGame.getInstance().getDatabase().setTime(player, timeTaken))).thenAcceptAsync(v -> {
                    GameUtils.rewardPlayer(player);
                    GameUtils.broadcast(MessageProcessor.process(MessageKeys.HANGMAN_WIN.getMessage().replace("{player}", player.getName()).replace("{time}", formattedTime)));
                    this.handlePlayerWin(player);
                    this.cleanup();
                }, MainThreadExecutorService.getInstance().getMainThreadExecutor());
                PlayerUtils.sendToast(player, ConfigKeys.TOAST_MESSAGE, ConfigKeys.TOAST_MATERIAL, ConfigKeys.TOAST_ENABLED);
                GameUtils.playSoundToWinner(player, ConfigKeys.SOUND_WIN_ENABLED, ConfigKeys.SOUND_WIN_SOUND);
            }
        } else {
            ++this.wrongGuesses;
            if (this.isGameLost()) {
                this.gameWon = true;
                if (this.timeoutTask != null) {
                    this.timeoutTask.cancel();
                }
                GameUtils.broadcast(MessageProcessor.process(MessageKeys.HANGMAN_NO_WIN.getMessage().replace("{word}", this.correctWord)));
                this.handleGameTimeout();
                this.cleanup();
            } else {
                this.announceGame();
            }
        }
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.guessedLetters = null;
        this.playersWhoGuessed = null;
        this.correctWord = null;
        this.gameWon = false;
        this.wrongGuesses = 0;
    }

    private void announceGame() {
        String word = this.buildDisplayWord();
        String stages = this.buildStages();
        List<String> messages = MessageKeys.HANGMAN.getMessages();
        for (String message : messages) {
            String processedMessage = MessageProcessor.process(message.replace("{word}", word).replace("{stage}", stages));
            GameUtils.broadcast(processedMessage);
        }
    }

    @NotNull
    private String buildDisplayWord() {
        StringBuilder displayWord = new StringBuilder();
        String placeholders = MessageProcessor.process(ConfigKeys.HANGMAN_PLACEHOLDERS.getString());
        String foundFormat = MessageProcessor.process(ConfigKeys.HANGMAN_FOUND.getString());
        for (char letter : this.correctWord.toCharArray()) {
            if (this.guessedLetters.contains(Character.valueOf(letter))) {
                displayWord.append(foundFormat.replace("{letter}", String.valueOf(letter)));
                continue;
            }
            displayWord.append(placeholders);
        }
        return displayWord.toString();
    }

    @NotNull
    private String buildStages() {
        if (!ConfigKeys.HANGMAN_STAGES_ENABLED.getBoolean()) {
            return "";
        }
        Section stagesSection = McChatGame.getInstance().getConfiguration().getSection("hangman.stages");
        if (stagesSection == null) {
            return "";
        }
        StringBuilder stages = new StringBuilder();
        String stageInColor = MessageProcessor.process(ConfigKeys.HANGMAN_STAGE_IN.getString());
        String stageOutColor = MessageProcessor.process(ConfigKeys.HANGMAN_STAGE_OUT.getString());
        Set stageKeys = stagesSection.getRoutesAsStrings(false);
        List<Integer> sortedStageNumbers = Collections.synchronizedList(new ArrayList());
        for (String key : stageKeys) {
            try {
                sortedStageNumbers.add(Integer.parseInt(key));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        sortedStageNumbers.sort(Integer::compareTo);
        for (int i = 0; i < sortedStageNumbers.size(); ++i) {
            int stageNumber = (Integer)sortedStageNumbers.get(i);
            String stageLine = stagesSection.getString(String.valueOf(stageNumber));
            if (stageLine == null) continue;
            if (stageNumber <= this.wrongGuesses) {
                stages.append(stageInColor).append(stageLine);
            } else {
                stages.append(stageOutColor).append(stageLine);
            }
            if (i >= sortedStageNumbers.size() - 1) continue;
            stages.append("\n");
        }
        return stages.toString();
    }

    private boolean isWordComplete() {
        for (char letter : this.correctWord.toCharArray()) {
            if (this.guessedLetters.contains(Character.valueOf(letter))) continue;
            return false;
        }
        return true;
    }

    private boolean isGameLost() {
        Section stagesSection = McChatGame.getInstance().getConfiguration().getSection("hangman.stages");
        if (stagesSection == null) {
            return false;
        }
        int maxStages = stagesSection.getRoutesAsStrings(false).size();
        return this.wrongGuesses >= maxStages;
    }

    private void scheduleTimeout() {
        this.timeoutTask = McChatGame.getInstance().getScheduler().runTaskLater(() -> {
            if (this.state == GameState.ACTIVE && !this.gameWon) {
                GameUtils.broadcast(MessageProcessor.process(MessageKeys.HANGMAN_NO_WIN.getMessage().replace("{answer}", this.correctWord)));
                this.handleGameTimeout();
                this.cleanup();
            }
        }, (long)ConfigKeys.HANGMAN_TIME.getInt() * 20L);
    }
}

