/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.models.impl;

import com.mongenscave.mcchatgame.McChatGame;
import com.mongenscave.mcchatgame.identifiers.GameState;
import com.mongenscave.mcchatgame.identifiers.keys.ConfigKeys;
import com.mongenscave.mcchatgame.identifiers.keys.MessageKeys;
import com.mongenscave.mcchatgame.models.GameHandler;
import com.mongenscave.mcchatgame.processor.AutoGameProcessor;
import com.mongenscave.mcchatgame.services.MainThreadExecutorService;
import com.mongenscave.mcchatgame.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.mongenscave.mcchatgame.utils.GameUtils;
import com.mongenscave.mcchatgame.utils.PlayerUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GameMath
extends GameHandler {
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    private final AtomicBoolean winnerDetermined = new AtomicBoolean(false);
    private MyScheduledTask timeoutTask;
    private String correctAnswer;
    private long startTime;

    @Override
    public void start() {
        if (this.state == GameState.ACTIVE) {
            return;
        }
        List<String> problems = ConfigKeys.MATH_PROBLEMS.getList();
        if (problems.isEmpty()) {
            return;
        }
        String[] problemData = this.parseProblem(problems.get(this.random.nextInt(problems.size())));
        if (problemData == null) {
            return;
        }
        GameUtils.playSoundToEveryone(ConfigKeys.SOUND_START_ENABLED, ConfigKeys.SOUND_START_SOUND);
        this.correctAnswer = problemData[1];
        this.gameData = problemData[0];
        this.startTime = System.currentTimeMillis();
        this.winnerDetermined.set(false);
        this.setAsActive();
        this.announceProblem();
        this.scheduleTimeout();
    }

    @Override
    public void stop() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.cleanup();
        AutoGameProcessor gameProcessor = McChatGame.getInstance().getGameProcessor();
        gameProcessor.start();
    }

    @Override
    public void handleAnswer(@NotNull Player player, @NotNull String answer) {
        if (this.state != GameState.ACTIVE || !this.winnerDetermined.compareAndSet(false, true)) {
            return;
        }
        if (answer.trim().equalsIgnoreCase(this.correctAnswer)) {
            long endTime = System.currentTimeMillis();
            double timeTaken = (double)(endTime - this.startTime) / 1000.0;
            String formattedTime = String.format("%.2f", timeTaken);
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel();
            }
            ((CompletableFuture)McChatGame.getInstance().getDatabase().incrementWin(player).thenCompose(v -> McChatGame.getInstance().getDatabase().setTime(player, timeTaken))).thenAcceptAsync(v -> {
                GameUtils.rewardPlayer(player);
                GameUtils.broadcast(MessageKeys.MATH_GAME_WIN.getMessage().replace("{player}", player.getName()).replace("{time}", formattedTime));
                this.handlePlayerWin(player);
                this.cleanup();
            }, MainThreadExecutorService.getInstance().getMainThreadExecutor());
            PlayerUtils.sendToast(player, ConfigKeys.TOAST_MESSAGE, ConfigKeys.TOAST_MATERIAL, ConfigKeys.TOAST_ENABLED);
            GameUtils.playSoundToWinner(player, ConfigKeys.SOUND_WIN_ENABLED, ConfigKeys.SOUND_WIN_SOUND);
        } else {
            this.winnerDetermined.set(false);
        }
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    protected void cleanup() {
        this.winnerDetermined.set(false);
        super.cleanup();
    }

    @Nullable
    private String[] parseProblem(@NotNull String raw) {
        String[] parts = raw.split("=", 2);
        if (parts.length != 2) {
            return null;
        }
        return new String[]{parts[0].trim(), parts[1].trim()};
    }

    private void announceProblem() {
        String question = (String)this.gameData;
        GameUtils.broadcastMessages(MessageKeys.MATH_GAME, "{equation}", question);
    }

    private void scheduleTimeout() {
        this.timeoutTask = McChatGame.getInstance().getScheduler().runTaskLater(() -> {
            if (this.state == GameState.ACTIVE && this.winnerDetermined.compareAndSet(false, true)) {
                GameUtils.broadcast(MessageKeys.MATH_GAME_NO_WIN.getMessage().replace("{answer}", this.correctAnswer));
                this.handleGameTimeout();
                this.cleanup();
            }
        }, (long)ConfigKeys.MATH_TIME.getInt() * 20L);
    }
}

