/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.models.impl;

import com.mongenscave.mcchatgame.McChatGame;
import com.mongenscave.mcchatgame.identifiers.GameState;
import com.mongenscave.mcchatgame.identifiers.keys.ConfigKeys;
import com.mongenscave.mcchatgame.identifiers.keys.MessageKeys;
import com.mongenscave.mcchatgame.models.GameHandler;
import com.mongenscave.mcchatgame.processor.AutoGameProcessor;
import com.mongenscave.mcchatgame.services.MainThreadExecutorService;
import com.mongenscave.mcchatgame.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.mongenscave.mcchatgame.utils.GameUtils;
import com.mongenscave.mcchatgame.utils.PlayerUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class GameRange
extends GameHandler {
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    private final AtomicBoolean winnerDetermined = new AtomicBoolean(false);
    private MyScheduledTask timeoutTask;
    private int targetNumber;
    private int minRange;
    private int maxRange;
    private long startTime;

    @Override
    public void start() {
        if (this.state == GameState.ACTIVE) {
            return;
        }
        String rangeConfig = ConfigKeys.RANGE_RANGE.getString();
        if (rangeConfig.trim().isEmpty()) {
            return;
        }
        String[] rangeParts = rangeConfig.split("-");
        if (rangeParts.length != 2) {
            return;
        }
        try {
            this.minRange = Integer.parseInt(rangeParts[0].trim());
            this.maxRange = Integer.parseInt(rangeParts[1].trim());
        }
        catch (NumberFormatException exception) {
            return;
        }
        if (this.minRange >= this.maxRange) {
            return;
        }
        GameUtils.playSoundToEveryone(ConfigKeys.SOUND_START_ENABLED, ConfigKeys.SOUND_START_SOUND);
        this.targetNumber = this.random.nextInt(this.minRange, this.maxRange + 1);
        this.gameData = String.valueOf(this.targetNumber);
        this.startTime = System.currentTimeMillis();
        this.winnerDetermined.set(false);
        this.setAsActive();
        this.announceRange();
        this.scheduleTimeout();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void stop() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.cleanup();
        AutoGameProcessor gameProcessor = McChatGame.getInstance().getGameProcessor();
        gameProcessor.start();
    }

    @Override
    public void handleAnswer(@NotNull Player player, @NotNull String answer) {
        if (this.state != GameState.ACTIVE || !this.winnerDetermined.compareAndSet(false, true)) {
            return;
        }
        try {
            int guessedNumber = Integer.parseInt(answer.trim());
            if (guessedNumber == this.targetNumber) {
                long endTime = System.currentTimeMillis();
                double timeTaken = (double)(endTime - this.startTime) / 1000.0;
                String formattedTime = String.format("%.2f", timeTaken);
                if (this.timeoutTask != null) {
                    this.timeoutTask.cancel();
                }
                ((CompletableFuture)McChatGame.getInstance().getDatabase().incrementWin(player).thenCompose(v -> McChatGame.getInstance().getDatabase().setTime(player, timeTaken))).thenAcceptAsync(v -> {
                    GameUtils.rewardPlayer(player);
                    GameUtils.broadcast(MessageKeys.RANGE_WIN.getMessage().replace("{player}", player.getName()).replace("{number}", String.valueOf(this.targetNumber)).replace("{time}", formattedTime));
                    this.handlePlayerWin(player);
                    this.cleanup();
                }, MainThreadExecutorService.getInstance().getMainThreadExecutor());
                PlayerUtils.sendToast(player, ConfigKeys.TOAST_MESSAGE, ConfigKeys.TOAST_MATERIAL, ConfigKeys.TOAST_ENABLED);
                GameUtils.playSoundToWinner(player, ConfigKeys.SOUND_WIN_ENABLED, ConfigKeys.SOUND_WIN_SOUND);
            } else {
                this.winnerDetermined.set(false);
            }
        }
        catch (NumberFormatException exception) {
            this.winnerDetermined.set(false);
        }
    }

    @Override
    protected void cleanup() {
        this.winnerDetermined.set(false);
        super.cleanup();
    }

    private void announceRange() {
        GameUtils.broadcastMessages(MessageKeys.RANGE, new String[0]);
    }

    private void scheduleTimeout() {
        this.timeoutTask = McChatGame.getInstance().getScheduler().runTaskLater(() -> {
            if (this.state == GameState.ACTIVE && this.winnerDetermined.compareAndSet(false, true)) {
                GameUtils.broadcast(MessageKeys.RANGE_NO_WIN.getMessage().replace("{answer}", String.valueOf(this.targetNumber)).replace("{min}", String.valueOf(this.minRange)).replace("{max}", String.valueOf(this.maxRange)));
                this.handleGameTimeout();
                this.cleanup();
            }
        }, (long)ConfigKeys.RANGE_TIME.getInt() * 20L);
    }
}

