/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.models.impl;

import com.mongenscave.mcchatgame.McChatGame;
import com.mongenscave.mcchatgame.identifiers.GameState;
import com.mongenscave.mcchatgame.identifiers.keys.ConfigKeys;
import com.mongenscave.mcchatgame.identifiers.keys.MessageKeys;
import com.mongenscave.mcchatgame.models.GameHandler;
import com.mongenscave.mcchatgame.processor.AutoGameProcessor;
import com.mongenscave.mcchatgame.services.MainThreadExecutorService;
import com.mongenscave.mcchatgame.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.mongenscave.mcchatgame.utils.GameUtils;
import com.mongenscave.mcchatgame.utils.PlayerUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameWordStop
extends GameHandler {
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    private final AtomicBoolean winnerDetermined = new AtomicBoolean(false);
    private MyScheduledTask timeoutTask;
    private String correctMob;
    private long startTime;

    @Override
    public void start() {
        if (this.state == GameState.ACTIVE) {
            return;
        }
        List<String> mobs = ConfigKeys.WORD_STOP_MOBS.getList();
        if (mobs.isEmpty()) {
            return;
        }
        String[] mobData = this.parseMob(mobs.get(this.random.nextInt(mobs.size())));
        if (mobData == null) {
            return;
        }
        this.correctMob = mobData[1];
        this.gameData = mobData[0];
        this.startTime = System.currentTimeMillis();
        this.winnerDetermined.set(false);
        this.setAsActive();
        GameUtils.playSoundToEveryone(ConfigKeys.SOUND_START_ENABLED, ConfigKeys.SOUND_START_SOUND);
        this.announceClue();
        this.scheduleTimeout();
    }

    @Override
    public void stop() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.cleanup();
        AutoGameProcessor gameProcessor = McChatGame.getInstance().getGameProcessor();
        gameProcessor.start();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void handleAnswer(@NotNull Player player, @NotNull String answer) {
        if (this.state != GameState.ACTIVE || !this.winnerDetermined.compareAndSet(false, true)) {
            return;
        }
        if (answer.trim().equalsIgnoreCase(this.correctMob)) {
            long endTime = System.currentTimeMillis();
            double timeTaken = (double)(endTime - this.startTime) / 1000.0;
            String formattedTime = String.format("%.2f", timeTaken);
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel();
            }
            ((CompletableFuture)McChatGame.getInstance().getDatabase().incrementWin(player).thenCompose(v -> McChatGame.getInstance().getDatabase().setTime(player, timeTaken))).thenAcceptAsync(v -> {
                GameUtils.rewardPlayer(player);
                GameUtils.broadcast(MessageKeys.WORD_STOP_WIN.getMessage().replace("{player}", player.getName()).replace("{time}", formattedTime));
                this.handlePlayerWin(player);
                this.cleanup();
            }, MainThreadExecutorService.getInstance().getMainThreadExecutor());
            PlayerUtils.sendToast(player, ConfigKeys.TOAST_MESSAGE, ConfigKeys.TOAST_MATERIAL, ConfigKeys.TOAST_ENABLED);
            GameUtils.playSoundToWinner(player, ConfigKeys.SOUND_WIN_ENABLED, ConfigKeys.SOUND_WIN_SOUND);
        } else {
            this.winnerDetermined.set(false);
        }
    }

    @Override
    protected void cleanup() {
        this.winnerDetermined.set(false);
        super.cleanup();
    }

    @Nullable
    private String[] parseMob(@NotNull String raw) {
        String[] parts = raw.split("=", 2);
        if (parts.length != 2) {
            return null;
        }
        return new String[]{parts[0].trim(), parts[1].trim()};
    }

    private void announceClue() {
        String letter = (String)this.gameData;
        GameUtils.broadcastMessages(MessageKeys.WORD_STOP, "{character}", letter);
    }

    private void scheduleTimeout() {
        this.timeoutTask = McChatGame.getInstance().getScheduler().runTaskLater(() -> {
            if (this.state == GameState.ACTIVE && this.winnerDetermined.compareAndSet(false, true)) {
                GameUtils.broadcast(MessageKeys.WORD_STOP_NO_WIN.getMessage().replace("{answer}", this.correctMob));
                this.handleGameTimeout();
                this.cleanup();
            }
        }, (long)ConfigKeys.WORD_STOP_TIME.getInt() * 20L);
    }
}

