/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.processor;

import com.mongenscave.mcchatgame.McChatGame;
import com.mongenscave.mcchatgame.identifiers.GameType;
import com.mongenscave.mcchatgame.identifiers.keys.ConfigKeys;
import com.mongenscave.mcchatgame.managers.GameManager;
import com.mongenscave.mcchatgame.universalScheduler.scheduling.tasks.MyScheduledTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class AutoGameProcessor {
    private final List<GameType> GAME_POOL = Collections.synchronizedList(new ArrayList<GameType>(Arrays.asList(GameType.values())));
    private MyScheduledTask task;
    private final ThreadLocalRandom random = ThreadLocalRandom.current();

    public void start() {
        this.stopExistingTask();
        this.scheduleNewTask();
    }

    public void stop() {
        this.stopExistingTask();
    }

    private void stopExistingTask() {
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
    }

    private void scheduleNewTask() {
        this.stopExistingTask();
        long checkIntervalTicks = 20L;
        this.task = McChatGame.getInstance().getScheduler().runTaskLater(this::checkAndStartGame, checkIntervalTicks);
    }

    private void checkAndStartGame() {
        int activeGames = GameManager.getActiveGameCount();
        long currentTime = System.currentTimeMillis();
        long lastGameEnd = GameManager.getLastGameEndTime();
        long cooldownPeriod = (long)ConfigKeys.TIME_BETWEEN_GAMES.getInt() * 1000L;
        GameManager.removeInactiveGames();
        int onlinePlayers = Bukkit.getOnlinePlayers().size();
        int minPlayers = ConfigKeys.MIN_PLAYERS.getInt();
        if (onlinePlayers < minPlayers) {
            this.scheduleNewTask();
            return;
        }
        if (activeGames == 0 && (lastGameEnd == 0L || currentTime - lastGameEnd >= cooldownPeriod)) {
            this.startRandomGame();
        }
        this.scheduleNewTask();
    }

    private void startRandomGame() {
        List<GameType> enabledGames = this.getEnabledGames();
        if (enabledGames.isEmpty()) {
            return;
        }
        GameType randomType = enabledGames.get(this.random.nextInt(enabledGames.size()));
        GameManager.startGame(randomType);
    }

    @NotNull
    private List<GameType> getEnabledGames() {
        List<GameType> enabledGames = Collections.synchronizedList(new ArrayList());
        for (GameType gameType : this.GAME_POOL) {
            boolean isEnabled = false;
            switch (gameType) {
                case MATH: {
                    isEnabled = ConfigKeys.MATH_ENABLED.getBoolean();
                    break;
                }
                case RANDOM_CHARACTERS: {
                    isEnabled = ConfigKeys.RANDOM_CHARACTERS_ENABLED.getBoolean();
                    break;
                }
                case WHO_AM_I: {
                    isEnabled = ConfigKeys.WHO_AM_I_ENABLED.getBoolean();
                    break;
                }
                case WORD_STOP: {
                    isEnabled = ConfigKeys.WORD_STOP_ENABLED.getBoolean();
                    break;
                }
                case WORD_GUESSER: {
                    isEnabled = ConfigKeys.WORD_GUESSER_ENABLED.getBoolean();
                    break;
                }
                case REVERSE: {
                    isEnabled = ConfigKeys.REVERSE_ENABLED.getBoolean();
                    break;
                }
                case FILL_OUT: {
                    isEnabled = ConfigKeys.FILL_OUT_ENABLED.getBoolean();
                    break;
                }
                case CRAFTING: {
                    isEnabled = ConfigKeys.CRAFTING_ENABLED.getBoolean();
                    break;
                }
                case HANGMAN: {
                    isEnabled = ConfigKeys.HANGMAN_ENABLED.getBoolean();
                    break;
                }
                case RANGE: {
                    isEnabled = ConfigKeys.RANGE_ENABLED.getBoolean();
                }
            }
            if (!isEnabled) continue;
            enabledGames.add(gameType);
        }
        return enabledGames;
    }
}

