/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.services;

import com.mongenscave.mcchatgame.McChatGame;
import com.mongenscave.mcchatgame.utils.LoggerUtils;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MainThreadExecutorService {
    private static MainThreadExecutorService instance;
    private final Executor mainThreadExecutor = this.createMainThreadExecutor();

    private MainThreadExecutorService() {
    }

    public static void initialize() {
        instance = new MainThreadExecutorService();
    }

    @NotNull
    @Contract(pure=true)
    private Executor createMainThreadExecutor() {
        return command -> {
            if (McChatGame.getInstance().getServer().isPrimaryThread()) {
                try {
                    command.run();
                }
                catch (Exception exception) {
                    LoggerUtils.error(exception.getMessage(), new Object[0]);
                }
            } else {
                McChatGame.getInstance().getScheduler().runTask(() -> {
                    try {
                        command.run();
                    }
                    catch (Exception exception) {
                        LoggerUtils.error(exception.getMessage(), new Object[0]);
                    }
                });
            }
        };
    }

    @Generated
    public static MainThreadExecutorService getInstance() {
        return instance;
    }

    @Generated
    public Executor getMainThreadExecutor() {
        return this.mainThreadExecutor;
    }
}

