/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.update;

import com.mongenscave.mcchatgame.McChatGame;
import com.mongenscave.mcchatgame.identifiers.keys.MessageKeys;
import com.mongenscave.mcchatgame.utils.LoggerUtils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker
implements Listener {
    private static final Duration CHECK_INTERVAL = Duration.ofMinutes(30L);
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(10L);
    private static final long NOTIFICATION_DELAY_TICKS = 50L;
    private static final McChatGame plugin = McChatGame.getInstance();
    private final String currentVersion;
    private final int resourceId;
    private final HttpClient httpClient;
    private final AtomicReference<String> latestVersion = new AtomicReference();
    private final AtomicBoolean isUpToDate = new AtomicBoolean(true);

    public UpdateChecker(int resourceId) {
        this.currentVersion = plugin.getDescription().getVersion();
        this.resourceId = resourceId;
        this.httpClient = HttpClient.newBuilder().connectTimeout(REQUEST_TIMEOUT).build();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.startUpdateChecker();
    }

    @EventHandler
    public void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.isUpToDate.get() || this.latestVersion.get() == null) {
            return;
        }
        if (!player.hasPermission("mctreasure.update")) {
            return;
        }
        plugin.getScheduler().runTaskLaterAsynchronously(() -> player.sendMessage(MessageKeys.UPDATE_NOTIFY.getMessage().replace("{your}", this.currentVersion).replace("{latest}", this.latestVersion.get())), 50L);
    }

    @NotNull
    private CompletableFuture<Boolean> checkForUpdates() {
        return this.fetchLatestVersion().thenApply(version -> {
            this.latestVersion.set((String)version);
            boolean upToDate = version == null || this.isCurrentVersionLatest((String)version);
            this.isUpToDate.set(upToDate);
            return !upToDate;
        });
    }

    @NotNull
    private CompletableFuture<String> fetchLatestVersion() {
        URI uri = URI.create("https://api.polymart.org/v1/getResourceInfoSimple/?resource_id=" + this.resourceId + "&key=version");
        HttpRequest request = HttpRequest.newBuilder().uri(uri).timeout(REQUEST_TIMEOUT).GET().build();
        return ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).exceptionally(throwable -> {
            LoggerUtils.error("Failed to fetch latest version", throwable);
            return null;
        });
    }

    private boolean isCurrentVersionLatest(@Nullable String latest) {
        return latest == null || this.compareVersions(latest, this.currentVersion) <= 0;
    }

    private int compareVersions(String version1, String version2) {
        if (version1 == null || version2 == null) {
            return 0;
        }
        try {
            int[] v1Parts = this.parseVersion(version1);
            int[] v2Parts = this.parseVersion(version2);
            return v1Parts[0] != v2Parts[0] ? Integer.compare(v1Parts[0], v2Parts[0]) : (v1Parts[1] != v2Parts[1] ? Integer.compare(v1Parts[1], v2Parts[1]) : Integer.compare(v1Parts[2], v2Parts[2]));
        }
        catch (Exception exception) {
            LoggerUtils.warn("Failed to compare versions: {} vs {}", version1, version2, exception);
            return 0;
        }
    }

    @NotNull
    @Contract(value="_ -> new")
    private int[] parseVersion(@NotNull String version) {
        String[] parts = version.split("\\.", 3);
        return new int[]{parts.length > 0 ? Integer.parseInt(parts[0]) : 0, parts.length > 1 ? Integer.parseInt(parts[1]) : 0, parts.length > 2 ? Integer.parseInt(parts[2]) : 0};
    }

    private void startUpdateChecker() {
        long intervalTicks = CHECK_INTERVAL.toSeconds() * 20L;
        plugin.getScheduler().runTaskTimerAsynchronously(() -> ((CompletableFuture)this.checkForUpdates().thenAccept(updateAvailable -> {
            if (updateAvailable.booleanValue()) {
                plugin.getScheduler().runTaskLaterAsynchronously(() -> Bukkit.getConsoleSender().sendMessage(MessageKeys.UPDATE_NOTIFY.getMessage().replace("{your}", this.currentVersion).replace("{latest}", this.latestVersion.get())), 50L);
            }
        })).exceptionally(throwable -> {
            LoggerUtils.warn("Failed to check for updates", throwable);
            return null;
        }), 0L, intervalTicks);
    }

    public void shutdown() {
        this.httpClient.close();
    }

    @Generated
    public String getCurrentVersion() {
        return this.currentVersion;
    }
}

