/*
 * Decompiled with CFR 0.152.
 */
package com.mongenscave.mcchatgame.utils;

import com.mongenscave.mcchatgame.McChatGame;
import com.mongenscave.mcchatgame.data.WeightedReward;
import com.mongenscave.mcchatgame.identifiers.keys.ConfigKeys;
import com.mongenscave.mcchatgame.identifiers.keys.MessageKeys;
import com.mongenscave.mcchatgame.processor.MessageProcessor;
import com.mongenscave.mcchatgame.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GameUtils {
    private static final ThreadLocalRandom random = ThreadLocalRandom.current();
    private static final Pattern CHANCE_PATTERN = Pattern.compile("\\[(\\d+)]\\s*(.+)");

    public static void rewardPlayer(@NotNull Player winner) {
        List<String> rewardConfigs = ConfigKeys.REWARDS.getList();
        if (rewardConfigs.isEmpty()) {
            return;
        }
        List<WeightedReward> weightedRewards = GameUtils.parseRewards(rewardConfigs);
        if (weightedRewards.isEmpty()) {
            return;
        }
        WeightedReward selectedReward = GameUtils.selectWeightedReward(weightedRewards);
        if (selectedReward == null) {
            return;
        }
        String command = selectedReward.command().replace("{player}", winner.getName());
        McChatGame.getInstance().getScheduler().runTask(() -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command));
    }

    public static void broadcast(@NotNull String message) {
        Bukkit.getOnlinePlayers().forEach(player -> player.sendMessage(message));
    }

    public static void playSoundToEveryone(@NotNull ConfigKeys enabled, @NotNull ConfigKeys sound) {
        if (!enabled.getBoolean()) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(player -> player.playSound(player.getLocation(), sound.getString(), 0.5f, 1.0f));
    }

    public static void playSoundToWinner(@NotNull Player player, @NotNull ConfigKeys enabled, @NotNull ConfigKeys sound) {
        if (!enabled.getBoolean()) {
            return;
        }
        player.playSound(player.getLocation(), sound.getString(), 0.5f, 1.0f);
    }

    public static void broadcastMessages(@NotNull MessageKeys messages, String ... placeholders) {
        for (String message : messages.getMessages()) {
            GameUtils.broadcast(MessageProcessor.process(GameUtils.applyPlaceholders(message, placeholders)));
        }
    }

    private static String applyPlaceholders(@NotNull String message, String ... placeholders) {
        for (int i = 0; i < placeholders.length; i += 2) {
            message = message.replace(placeholders[i], placeholders[i + 1]);
        }
        return message;
    }

    @NotNull
    private static List<WeightedReward> parseRewards(@NotNull List<String> rewardConfigs) {
        List<WeightedReward> rewards = Collections.synchronizedList(new ArrayList());
        for (String config : rewardConfigs) {
            if (config == null || config.trim().isEmpty()) continue;
            Matcher matcher = CHANCE_PATTERN.matcher(config.trim());
            if (matcher.matches()) {
                try {
                    int weight = Integer.parseInt(matcher.group(1));
                    String command = matcher.group(2).trim();
                    if (weight <= 0 || command.isEmpty()) continue;
                    rewards.add(new WeightedReward(weight, command));
                }
                catch (NumberFormatException exception) {
                    LoggerUtils.error("Invalid reward config: " + config, new Object[0]);
                }
                continue;
            }
            rewards.add(new WeightedReward(1, config.trim()));
        }
        return rewards;
    }

    @Nullable
    private static WeightedReward selectWeightedReward(@NotNull List<WeightedReward> rewards) {
        if (rewards.isEmpty()) {
            return null;
        }
        int totalWeight = rewards.stream().mapToInt(WeightedReward::weight).sum();
        if (totalWeight <= 0) {
            return null;
        }
        int randomValue = random.nextInt(totalWeight);
        int currentWeight = 0;
        for (WeightedReward reward : rewards) {
            if (randomValue >= (currentWeight += reward.weight())) continue;
            return reward;
        }
        return rewards.getLast();
    }

    @Generated
    private GameUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

