/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.bukkit.hooks;

import java.util.List;
import java.util.StringJoiner;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.Lamp;
import revxrsal.commands.bukkit.actor.ActorFactory;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.bukkit.util.BukkitUtils;
import revxrsal.commands.stream.MutableStringStream;
import revxrsal.commands.stream.StringStream;
import revxrsal.commands.util.Collections;
import revxrsal.commands.util.Strings;

public final class LampCommandExecutor<A extends BukkitCommandActor>
implements TabExecutor {
    @NotNull
    private final Lamp<A> lamp;
    @NotNull
    private final ActorFactory<A> actorFactory;

    public LampCommandExecutor(@NotNull Lamp<A> lamp, @NotNull ActorFactory<A> actorFactory) {
        this.lamp = lamp;
        this.actorFactory = actorFactory;
    }

    private static String ignoreAfterSpace(String v) {
        int spaceIndex = v.indexOf(32);
        return spaceIndex == -1 ? v : v.substring(0, spaceIndex);
    }

    @NotNull
    private static MutableStringStream createInput(String commandName, String[] args) {
        StringJoiner userInput = new StringJoiner(" ");
        userInput.add(Strings.stripNamespace((String)commandName));
        for (String arg : args) {
            userInput.add(arg);
        }
        return StringStream.createMutable((String)userInput.toString());
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        A actor = this.actorFactory.create(sender, this.lamp);
        MutableStringStream input = LampCommandExecutor.createInput(command.getName(), args);
        this.lamp.dispatch(actor, (StringStream)input);
        return true;
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        A actor = this.actorFactory.create(sender, this.lamp);
        MutableStringStream input = LampCommandExecutor.createInput(command.getName(), args);
        List completions = this.lamp.autoCompleter().complete(actor, (StringStream)input);
        if (BukkitUtils.isBrigadierAvailable()) {
            return completions;
        }
        return Collections.map((Iterable)completions, LampCommandExecutor::ignoreAfterSpace);
    }
}

