/*
 * Decompiled with CFR 0.152.
 */
package modern_chunk_detector;

import java.util.concurrent.CopyOnWriteArrayList;
import modern_chunk_detector.ChunkScanner;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9848;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ModernChunkDetectorClient
implements ClientModInitializer {
    public static CopyOnWriteArrayList<class_1923> chunk_to_render = new CopyOnWriteArrayList();
    private static class_304 toogle_key;
    private static boolean is_mod_enabled;
    private final class_310 client = class_310.method_1551();
    private static final int DARK_CYAN;
    private static final int YELLOW;

    public void onInitializeClient() {
        System.out.println("[Modern Chunk Detector] Mod Initialized!");
        toogle_key = KeyBindingHelper.registerKeyBinding((class_304)new class_304("toogle_key.modern_chunk_detector", class_3675.class_307.field_1668, 79, new class_304.class_11900(class_2960.method_60654((String)"modern_chunk_detector.ayabusa"))));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (toogle_key.method_1436()) {
                if (is_mod_enabled) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7b[\u00a7dModern chunk detector\u00a7b] \u00a7fChunk detection is \u00a7cOFF"), false);
                    is_mod_enabled = false;
                    continue;
                }
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7b[\u00a7dModern chunk detector\u00a7b] \u00a7fChunk detection is \u00a7aON"), false);
                is_mod_enabled = true;
            }
        });
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            ChunkScanner scanner = new ChunkScanner(chunk);
            scanner.start();
        });
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> chunk_to_render.remove(chunk.method_12004()));
        WorldRenderEvents.BEFORE_DEBUG_RENDER.register(context -> {
            if (is_mod_enabled) {
                class_4587 matrices = context.matrices();
                class_4597 vertexConsumers = context.consumers();
                double cameraX = context.gameRenderer().method_19418().method_19326().field_1352;
                double cameraY = context.gameRenderer().method_19418().method_19326().field_1351;
                double cameraZ = context.gameRenderer().method_19418().method_19326().field_1350;
                for (class_1923 i : chunk_to_render) {
                    this.render(matrices, vertexConsumers, cameraX, cameraY, cameraZ, i);
                }
            }
        });
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ, class_1923 chunkPos) {
        float l;
        int k;
        int j;
        class_1297 entity = this.client.field_1773.method_19418().method_19331();
        float f = (float)((double)this.client.field_1687.method_31607() - cameraY);
        float g = (float)((double)this.client.field_1687.method_31605() - cameraY);
        float h = (float)((double)chunkPos.method_8326() - cameraX);
        float i = (float)((double)chunkPos.method_8328() - cameraZ);
        class_4588 vertexConsumer = vertexConsumers.method_73477(class_1921.method_49043((double)1.0));
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        for (j = -16; j <= 32; j += 16) {
            for (k = -16; k <= 32; k += 16) {
            }
        }
        for (j = 2; j < 16; j += 2) {
        }
        for (j = 2; j < 16; j += 2) {
        }
        for (j = this.client.field_1687.method_31607(); j <= this.client.field_1687.method_31605(); j += 2) {
            l = (float)((double)j - cameraY);
            int m = j % 8 == 0 ? DARK_CYAN : YELLOW;
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(1.0f, 0.0f, 1.0f, 0.0f);
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(1.0f, 0.0f, 1.0f, 1.0f);
            vertexConsumer.method_22918(matrix4f, h, l, i + 16.0f).method_22915(1.0f, 0.0f, 1.0f, 1.0f);
            vertexConsumer.method_22918(matrix4f, h + 16.0f, l, i + 16.0f).method_22915(1.0f, 0.0f, 1.0f, 1.0f);
            vertexConsumer.method_22918(matrix4f, h + 16.0f, l, i).method_22915(1.0f, 0.0f, 1.0f, 1.0f);
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(1.0f, 0.0f, 1.0f, 1.0f);
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(1.0f, 0.0f, 1.0f, 0.0f);
        }
        vertexConsumer = vertexConsumers.method_73477(class_1921.method_49043((double)2.0));
        for (j = 0; j <= 16; j += 16) {
            for (k = 0; k <= 16; k += 16) {
                vertexConsumer.method_22918(matrix4f, h + (float)j, f, i + (float)k).method_22915(1.0f, 0.0f, 1.0f, 0.0f);
                vertexConsumer.method_22918(matrix4f, h + (float)j, f, i + (float)k).method_22915(1.0f, 0.0f, 1.0f, 1.0f);
                vertexConsumer.method_22918(matrix4f, h + (float)j, g, i + (float)k).method_22915(1.0f, 0.0f, 1.0f, 1.0f);
                vertexConsumer.method_22918(matrix4f, h + (float)j, g, i + (float)k).method_22915(1.0f, 0.0f, 1.0f, 0.0f);
            }
        }
        for (j = this.client.field_1687.method_31607(); j <= this.client.field_1687.method_31605(); j += 16) {
            l = (float)((double)j - cameraY);
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(1.0f, 0.0f, 1.0f, 0.0f);
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(1.0f, 0.0f, 1.0f, 1.0f);
            vertexConsumer.method_22918(matrix4f, h, l, i + 16.0f).method_22915(1.0f, 0.0f, 1.0f, 1.0f);
            vertexConsumer.method_22918(matrix4f, h + 16.0f, l, i + 16.0f).method_22915(1.0f, 0.0f, 1.0f, 1.0f);
            vertexConsumer.method_22918(matrix4f, h + 16.0f, l, i).method_22915(1.0f, 0.0f, 1.0f, 1.0f);
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(1.0f, 0.0f, 1.0f, 1.0f);
            vertexConsumer.method_22918(matrix4f, h, l, i).method_22915(1.0f, 0.0f, 1.0f, 0.0f);
        }
    }

    static {
        is_mod_enabled = true;
        DARK_CYAN = class_9848.method_61324((int)255, (int)0, (int)155, (int)155);
        YELLOW = class_9848.method_61324((int)255, (int)255, (int)255, (int)0);
    }
}

