#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#
#                      DATAPACK INFO                     #
# ------------------------------------------------------ #
#     Author: GenMode                                    #
#     URL: https://github.com/GenMode/Minecraft/wiki     #
#                                                        #
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#

# Initialize
execute store result storage data_api:private player_locator.lore int 1 run data get entity @s Item.components."minecraft:lore"

# Prepare Data
$execute if data storage data_api:private player_locator{lore: 1} \
    run data modify entity @s Item.components."minecraft:lore" prepend value {\
        color: "gray", \
        italic: false, \
        translate: "%s: %s", \
        with: [{"translate": "entity.minecraft.player"}, {color: "yellow", text: "$(name)"}]}
execute unless data storage data_api:private player_locator{lore: 1} run data remove entity @s Item.components."minecraft:lore"[0]
$execute unless data storage data_api:private player_locator{lore: 1} \
    run data modify entity @s Item.components."minecraft:lore" insert 0 value {\
        color: "gray", \
        italic: false, \
        translate: "%s: %s", \
        with: [{"translate": "entity.minecraft.player"}, {color: "yellow", text: "$(name)"}]}

# Set Feedback
$execute if entity $(name) run data modify storage data_api:private player_locator.feedback set value {\
    translate: "%s: %s", \
    with: [{translate: "mco.configure.world.location"}, {translate: "x%s, y%s, z%s (%s)", with: ["?", "?", "?", "???"]}]}
$execute if entity $(name) store result storage data_api:private player_locator.feedback.with[1].with[0] int 1 run data get entity $(name) Pos[0]
$execute if entity $(name) store result storage data_api:private player_locator.feedback.with[1].with[1] int 1 run data get entity $(name) Pos[1]
$execute if entity $(name) store result storage data_api:private player_locator.feedback.with[1].with[2] int 1 run data get entity $(name) Pos[2]
$execute if entity $(name) run data modify storage data_api:private player_locator.feedback.with[1].with[3] set from entity $(name) Dimension

# If Player 
$execute if entity $(name) \
    run function data_api:command/run_command/from_array {commands: [\
        'data modify entity @s Item.components."minecraft:enchantment_glint_override" set value true', \
        'data modify entity @s Item.components."minecraft:lodestone_tracker" set value {target: {dimension: "minecraft:overworld", pos: [0, 0, 0]}, tracked: false}', \
        'data modify entity @s Item.components."minecraft:lodestone_tracker".target.dimension set from entity $(name) Dimension', \
        'data modify entity @s Item.components."minecraft:lodestone_tracker".target.pos set from entity $(name) Pos', \
        'execute unless data entity @s Item.components."minecraft:custom_name" run data modify storage data_api:private player_locator.custom_name set from entity @s Item.components."minecraft:item_name"', \
        'execute if data storage data_api:private player_locator.custom_name run data modify storage data_api:private player_locator.custom_name.italic set value false', \
        'execute if data storage data_api:private player_locator.custom_name run data modify entity @s Item.components."minecraft:custom_name" set from storage data_api:private player_locator.custom_name']}
$execute if entity $(name) as @p[tag=private.data_api.operator] run function data_api:command/tell {\
    sound: "minecraft:entity.experience_orb.pickup", \
    text: {\
        color: "yellow", \
        interpret: true, \
        nbt: "player_locator.feedback", \
        storage: "data_api:private"}}
$effect give $(name) minecraft:glowing 10 0 true

# Unless Player 
$execute unless entity $(name) run data modify entity @s Item.components."minecraft:enchantment_glint_override" set value false
$execute unless entity $(name) run data remove entity @s Item.components."minecraft:lodestone_tracker"
$execute unless entity $(name) as @p[tag=private.data_api.operator] run function data_api:command/tell {\
    sound: "minecraft:block.note_block.snare", \
    text: {color: "red", translate: "gui.socialInteractions.search_empty"}}

# Close
data remove storage data_api:private player_locator