#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#
#                      DATAPACK INFO                     #
# ------------------------------------------------------ #
#     Author: GenMode                                    #
#     URL: https://github.com/GenMode/Minecraft/wiki     #
#                                                        #
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#

# Initialize
function data_api:command/run_function/with_array {\
    function: "data_api:command/modify_data/trim", \
    inputs: [\
        {nbt: [block_entities, [{pack: "mojang:minecraft"}]], target: "data_api:store", type: "storage"}, \
        {nbt: [components, [{pack: "genmode:data_api"}]], target: "global:store", type: "storage"}, \
        {nbt: [item_tags, [{pack: "mojang:minecraft"}]], target: "data_api:store", type: "storage"}, \
        {nbt: [villager_level_up, [{pack: "genmode:data_api"}]], target: "data_api:store", type: "storage"}]}

# Modify Storage (block_entities)
data modify storage data_api:store block_entities append value {CustomName: {translate: "block.minecraft.anvil"}, data: {crafting_station: true, Items: [], Triggers: [7001000, 7001001, 7001002]}, id: "minecraft:anvil", pack: "mojang:minecraft"}
data modify storage data_api:store block_entities append value {CustomName: {translate: "block.minecraft.blast_furnace"}, data: {Items: {}, tags: ["#minecraft:furnaces"]}, id: "minecraft:blast_furnace", pack: "mojang:minecraft"}
data modify storage data_api:store block_entities append value {CustomName: {translate: "block.minecraft.campfire"}, data: {Items: [], tags: ["#minecraft:campfires"]}, id: "minecraft:campfire", pack: "mojang:minecraft"}
data modify storage data_api:store block_entities append value {CustomName: {translate: "block.minecraft.cauldron"}, id: "minecraft:cauldron", pack: "mojang:minecraft"}
data modify storage data_api:store block_entities append value {CustomName: {translate: "block.minecraft.chiseled_bookshelf"}, data: {item_count: 0, TransferCooldown: 0}, id: "minecraft:chiseled_bookshelf", pack: "mojang:minecraft"}
data modify storage data_api:store block_entities append value {CustomName: {translate: "block.minecraft.composter"}, data: {TransferCooldown:0}, id: "minecraft:composter", pack: "mojang:minecraft"}
data modify storage data_api:store block_entities append value {CustomName: {translate: "block.minecraft.enchanting_table"}, data: {crafting_station: true, Items: [], Triggers: [7001010, 7001011, 7001012]}, id: "minecraft:enchanting_table", pack: "mojang:minecraft"}
data modify storage data_api:store block_entities append value {CustomName: {translate: "block.minecraft.fletching_table"}, data: {crafting_station: true, Items: [], Triggers: [7001020, 7001021, 7001022]}, id: "minecraft:fletching_table", pack: "mojang:minecraft"}
data modify storage data_api:store block_entities append value {CustomName: {translate: "block.minecraft.furnace"}, data: {Items: {}, tags: ["#minecraft:furnaces"]}, id: "minecraft:furnace", pack: "mojang:minecraft"}
data modify storage data_api:store block_entities append value {CustomName: {translate: "block.minecraft.loom"}, data: {crafting_station: true, Items: [], Triggers: [7001040, 7001041, 7001042]}, id: "minecraft:loom", pack: "mojang:minecraft"}
data modify storage data_api:store block_entities append value {CustomName: {translate: "block.minecraft.smithing_table"}, data: {crafting_station: true, Items: [], Triggers:[7001030, 7001031, 7001032]}, id: "minecraft:smithing_table", pack: "mojang:minecraft"}
data modify storage data_api:store block_entities append value {CustomName: {translate: "block.minecraft.smoker"}, data: {Items: {}, tags: ["#minecraft:furnaces"]}, id: "minecraft:smoker", pack: "mojang:minecraft"}
data modify storage data_api:store block_entities append value {CustomName: {translate: "block.minecraft.soul_campfire"}, data: {Items: [], tags: ["#minecraft:campfires"]}, id: "minecraft:soul_campfire", pack: "mojang:minecraft"}

# Modify Storage (components)
data modify storage global:store components append value {id: "data_api:book", mode: "dynamic", pack: "genmode:data_api", type: "boolean", value: '"minecraft:custom_data".book'}
data modify storage global:store components append value {id: "data_api:compostable", mode: "dynamic", pack: "genmode:data_api", range: {min: 0, max: 100}, type: "int", value: '"minecraft:custom_data".compostable.value'}
data modify storage global:store components append value {id: "data_api:craftable_on", mode: "dynamic", pack: "genmode:data_api", type: "array", value: '"minecraft:custom_data".craftable_on.blocks'}
data modify storage global:store components append value {id: "data_api:dye_randomly", mode: "modifier", pack: "genmode:data_api", type: "boolean", value: 'data_api:function/dye_randomly'}
data modify storage global:store components append value {id: "data_api:item_commands", mode: "dynamic", pack: "genmode:data_api", type: "array", value: '"minecraft:custom_data".item_commands'}
data modify storage global:store components append value {id: "data_api:prevent_fuel", mode: "dynamic", pack: "genmode:data_api", type: "boolean", value: '"minecraft:custom_data".prevent_fuel'}

# Modify Storage (entities)
#data modify storage data_api:store villager_level_up append value {function: "...", pack: "genmode:data_api"}

# Modify Storage (item_tags)
data modify storage data_api:store item_tags append value {\
    function: 'data_api:command/run_function/with_array {\
        function: "data_api:block/crafting_station/item_tag", \
        inputs: [\
            {namespace: "minecraft", value: "amethyst_clusters"}, \
            {namespace: "minecraft", value: "axes"}, \
            {namespace: "minecraft", value: "azalea_flowers"}, \
            {namespace: "minecraft", value: "banner_patterns"}, \
            {namespace: "minecraft", value: "banners"}, \
            {namespace: "minecraft", value: "bars"}, \
            {namespace: "minecraft", value: "beds"}, \
            {namespace: "minecraft", value: "boats"}, \
            {namespace: "minecraft", value: "bookshelf_books"}, \
            {namespace: "minecraft", value: "bundles"}, \
            {namespace: "minecraft", value: "buttons"}, \
            {namespace: "minecraft", value: "candles"}, \
            {namespace: "minecraft", value: "chains"}, \
            {namespace: "minecraft", value: "cherry_flowers"}, \
            {namespace: "minecraft", value: "copper_lanterns"}, \
            {namespace: "minecraft", value: "chest_armor"}, \
            {namespace: "minecraft", value: "chests"}, \
            {namespace: "minecraft", value: "command_blocks"}, \
            {namespace: "minecraft", value: "copper_bars"}, \
            {namespace: "minecraft", value: "copper_chains"}, \
            {namespace: "minecraft", value: "copper_chests"}, \
            {namespace: "minecraft", value: "copper_golem_statues"}, \
            {namespace: "minecraft", value: "doors"}, \
            {namespace: "minecraft", value: "dyes"}, \
            {namespace: "minecraft", value: "eggs"}, \
            {namespace: "minecraft", value: "enchantable"}, \
            {namespace: "minecraft", value: "eyeblossoms"}, \
            {namespace: "minecraft", value: "ferns"}, \
            {namespace: "minecraft", value: "fish_buckets"}, \
            {namespace: "minecraft", value: "fishes"}, \
            {namespace: "minecraft", value: "flowers"}, \
            {namespace: "minecraft", value: "foot_armor"}, \
            {namespace: "minecraft", value: "froglights"}, \
            {namespace: "minecraft", value: "glass"}, \
            {namespace: "minecraft", value: "glass_crafting_materials"}, \
            {namespace: "minecraft", value: "glass_panes"}, \
            {namespace: "minecraft", value: "grasses"}, \
            {namespace: "minecraft", value: "hanging_signs"}, \
            {namespace: "minecraft", value: "has_dyed_color"}, \
            {namespace: "minecraft", value: "head_armor"}, \
            {namespace: "minecraft", value: "heads"}, \
            {namespace: "minecraft", value: "hoes"}, \
            {namespace: "minecraft", value: "horse_armor"}, \
            {namespace: "minecraft", value: "ingots"}, \
            {namespace: "minecraft", value: "ink_sacs"}, \
            {namespace: "minecraft", value: "lanterns"}, \
            {namespace: "minecraft", value: "leaves"}, \
            {namespace: "minecraft", value: "leg_armor"}, \
            {namespace: "minecraft", value: "lightning_rods"}, \
            {namespace: "minecraft", value: "logs"}, \
            {namespace: "minecraft", value: "minecarts"}, \
            {namespace: "minecraft", value: "mushroom_blocks"}, \
            {namespace: "minecraft", value: "mushrooms"}, \
            {namespace: "minecraft", value: "music_discs"}, \
            {namespace: "minecraft", value: "nuggets"}, \
            {namespace: "minecraft", value: "ores"}, \
            {namespace: "minecraft", value: "planks"}, \
            {namespace: "minecraft", value: "pickaxes"}, \
            {namespace: "minecraft", value: "potions"}, \
            {namespace: "minecraft", value: "pumpkins"}, \
            {namespace: "minecraft", value: "pottery_sherds"}, \
            {namespace: "minecraft", value: "produce"}, \
            {namespace: "minecraft", value: "raw_ore_blocks"}, \
            {namespace: "minecraft", value: "raw_ores"}, \
            {namespace: "minecraft", value: "roots"}, \
            {namespace: "minecraft", value: "saplings"}, \
            {namespace: "minecraft", value: "seeds"}, \
            {namespace: "minecraft", value: "shelves"}, \
            {namespace: "minecraft", value: "shovels"}, \
            {namespace: "minecraft", value: "shulker_boxes"}, \
            {namespace: "minecraft", value: "signs"}, \
            {namespace: "minecraft", value: "small_flowers"}, \
            {namespace: "minecraft", value: "stone_tool_materials"}, \
            {namespace: "minecraft", value: "swords"}, \
            {namespace: "minecraft", value: "tall_flowers"}, \
            {namespace: "minecraft", value: "torches"}, \
            {namespace: "minecraft", value: "trapdoors"}, \
            {namespace: "minecraft", value: "trim_materials"}, \
            {namespace: "minecraft", value: "trim_templates"}, \
            {namespace: "minecraft", value: "wooden_trapdoors"}, \
            {namespace: "minecraft", value: "wool"}]}', \
    pack: "mojang:minecraft"}

# Modify Data (items)
#data modify storage NAMESPACE:store items set value [{id: "...", item: {components: {id: "...", book: true, compostable: {...}, craftable_on: {blocks: ["..."]}, item_commands: [{...}], inv_drop: true, prevent_fuel: true, smelt_data: {...}, tags: [...]}, id: "..."}}]
data modify storage data_api:store items set value [\
    {id: "developer_food", item: {components: {"minecraft:custom_data": {compostable: {chance: 100}, craftable_on: {blocks: ["minecraft:anvil", "minecraft:enchanting_table", "minecraft:fletching_table", "minecraft:loom", "minecraft:smithing_table"]}, id: "data_api:developer_food", pack: "genmode:data_api"}, "minecraft:enchantment_glint_override": true, "minecraft:food": {nutrition: 2147483627, saturation: 2147483647}, "minecraft:item_name": {translate: "Developer Food"}, "minecraft:lore": [{color: "green", translate: "Data API"}], "minecraft:max_stack_size": 99, "minecraft:rarity": epic}, id: "minecraft:golden_carrot"}}, \
    {id: "developer_tool", item: {components: {"minecraft:custom_data": {book: true, id: "data_api:developer_tool", item_commands: [{run_command: "kill", on_target: true, trigger: "minecraft:player_hurt_entity"}, {sound: {pitch: "0.1", sound_id: "minecrafT:entity.item_frame.rotate_item", target: "@s"}, swap: [{id: "minecraft:netherite_pickaxe"}, {id: "minecraft:netherite_shovel"} ,{id: "minecraft:netherite_hoe"}, {id: "minecraft:netherite_axe"}], trigger: "minecraft:using_item"}], pack: "genmode:data_api"}, "minecraft:enchantment_glint_override": true, "minecraft:item_name": {translate: "Developer Tool"}, "minecraft:lore": [{color: "green", translate: "Data API"}], "minecraft:max_damage": 1000000, "minecraft:rarity": epic}, id: "minecraft:netherite_pickaxe"}}, \
    {id: "player_locator", item: {components: {"minecraft:custom_data": {id: "data_api:player_locator", item_commands: [{trigger: "minecraft:using_item", run_command: "execute as @n[tag=private.data_api.target] run function data_api:item/player_locator with entity @s Item.components.minecraft:profile"}], pack: "genmode:data_api"}, "minecraft:item_name": {"translate": "Player Locator"}, "minecraft:lore": [{color: "green", translate: "Data API"}], "minecraft:max_stack_size": 1, "minecraft:rarity": "epic"}, id: "minecraft:compass"}}]