#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#
#                      DATAPACK INFO                     #
# ------------------------------------------------------ #
#     Author: GenMode                                    #
#     URL: https://github.com/GenMode/Minecraft/wiki     #
#                                                        #
#%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%#

# Initialize
$data modify storage data_api:private export.items.list set from $(type) $(target) $(nbt)

# Set Container Size
execute if entity @s[type=#minecraft:llamas, tag=private.data_api.export_entity, nbt={Strength: 1}] run scoreboard players set *container_size private.data_api.export 2
execute if entity @s[type=#minecraft:llamas, tag=private.data_api.export_entity, nbt={Strength: 2}] run scoreboard players set *container_size private.data_api.export 5
execute if entity @s[type=#minecraft:llamas, tag=private.data_api.export_entity, nbt={Strength: 3}] run scoreboard players set *container_size private.data_api.export 8
execute if entity @s[type=#minecraft:llamas, tag=private.data_api.export_entity, nbt={Strength: 4}] run scoreboard players set *container_size private.data_api.export 11
execute if entity @s[type=#minecraft:llamas, tag=private.data_api.export_entity, nbt={Strength: 5}] run scoreboard players set *container_size private.data_api.export 14
execute if entity @s[type=minecraft:donkey, tag=private.data_api.export_entity] run scoreboard players set *container_size private.data_api.export 14
execute if entity @s[type=minecraft:mule, tag=private.data_api.export_entity] run scoreboard players set *container_size private.data_api.export 14
execute if entity @s[type=minecraft:player, tag=private.data_api.export_player] run scoreboard players set *container_size private.data_api.export 35
$function data_api:command/macro/_ {command: 'execute if block $(target) minecraft:brewing_stand run scoreboard players set *container_size private.data_api.export 4'}
$function data_api:command/macro/_ {command: 'execute if block $(target) minecraft:chiseled_bookshelf run scoreboard players set *container_size private.data_api.export 5'}
$function data_api:command/macro/_ {command: 'execute if block $(target) minecraft:dispenser run scoreboard players set *container_size private.data_api.export 8'}
$function data_api:command/macro/_ {command: 'execute if block $(target) minecraft:dropper run scoreboard players set *container_size private.data_api.export 8'}
$function data_api:command/macro/_ {command: 'execute if block $(target) #minecraft:furnaces run scoreboard players set *container_size private.data_api.export 1'}
$function data_api:command/macro/_ {command: 'execute if block $(target) minecraft:hopper run scoreboard players set *container_size private.data_api.export 4'}
execute unless score *container_size private.data_api.export matches 0.. run scoreboard players set *container_size private.data_api.export 26

# Prepare Data
data modify storage data_api:private export.value set from storage data_api:private export.items.list
data modify storage data_api:private export.items.value set from storage data_api:private export.from

# Prepare Scores
data modify storage data_api:private export.start set value 0
scoreboard players set *start private.data_api.export 0

# Prepare Max Stack Size
summon minecraft:item_display ~ -100 ~ {Item: {id: "minecraft:stone"}, Tags: ["private.data_api.export_item"]}
data modify entity @n[type=minecraft:item_display, tag=private.data_api.export_item] item set from storage data_api:private export.from
execute store result score *max_stack_size private.data_api.export run data get storage data_api:private export.from.components."minecraft:max_stack_size"
execute if score *max_stack_size private.data_api.export matches 0 as @n[type=minecraft:item_display, tag=private.data_api.export_item] if predicate data_api:tags/max_stack_size_1 run scoreboard players set *max_stack_size private.data_api.export 1
execute if score *max_stack_size private.data_api.export matches 0 as @n[type=minecraft:item_display, tag=private.data_api.export_item] if predicate data_api:tags/max_stack_size_16 run scoreboard players set *max_stack_size private.data_api.export 16
execute if score *max_stack_size private.data_api.export matches 0 run scoreboard players set *max_stack_size private.data_api.export 64
kill @e[type=minecraft:item_display, tag=private.data_api.export_item]

# Function
execute if data storage data_api:private export.items.list[0] run function data_api:command/modify_data/export/items_loop with storage data_api:private export.items
execute unless data storage data_api:private export.items.value{count: 0} run function data_api:command/modify_data/export/items_insert with storage data_api:private export

# Output Data
execute as @s[tag=private.data_api.export_ender_chest] run function data_api:command/modify_data/player with storage data_api:private export
execute as @s[tag=private.data_api.export_player] run function data_api:command/modify_data/player with storage data_api:private export
$execute unless entity @s[tag=private.data_api.export_player] run data modify $(type) $(target) $(nbt) set from storage data_api:private export.value
data modify storage data_api:private export.from set from storage data_api:private export.items.value

# Player
execute as @s[tag=private.data_api.export_player] unless data storage data_api:private export.items.value{count: 0} run scoreboard players set *container_size private.data_api.export 99
execute as @s[tag=private.data_api.export_player] unless data storage data_api:private export.items.value{count: 0} run function data_api:command/modify_data/export/items_summon