
# Initialize
$data modify storage global:private give.item set value '$(item)'
$function data_api:command/macro/_ {command: 'data modify storage global:private give.item set value $(item)'}
scoreboard objectives add private.global.give dummy

# Prepare Data
function data_api:command/run_command/as_ternary {\
    context: "data storage global:private give.item.id", \
    if: "data modify storage global:private give.output set from storage global:private give.item", \
    unless: "data modify storage global:private give.output.id set from storage global:private give.item"}
scoreboard players set *pass private.global.give 0

# Prepare Feedback
data modify storage global:private give.feedback set value {\
    data: {\
        count: 1, \
        input: "", \
        item: "", \
        summon: {\
            color: "white", \
            hover_event: {action: "show_item"}, \
            translate: "[%s]", \
            with: [{selector: "@n[type=minecraft:item, tag=private.global.item]"}]}}, \
    fail_item: {\
        color: "red", \
        translate: "%s\n%s", \
        with: [\
            {translate: "argument.item.id.invalid", with: [{nbt: "give.feedback.data.item", storage: "global:private"}]}, \
            {color: "gray", \
                translate: "give @s %s%s", \
                with: [\
                    {color: "red", nbt: "give.feedback.data.input", storage: "global:private", underlined: true}, \
                    {color: "red", italic: true, translate: "command.context.here"}]}]}, \
    fail_integer: {\
        color: "red", \
        translate: "%s\n%s", \
        with: [\
            {translate: "parsing.int.expected", with: [{nbt: "give.feedback.data.item", storage: "global:private"}]}, \
            {color: "gray", \
                translate: "... @s %s %s%s", \
                with: [\
                    {nbt: "give.feedback.data.input", storage: "global:private"}, \
                    {color: "red", nbt: "give.feedback.data.count", storage: "global:private", underlined: true}, \
                    {color: "red", italic: true, translate: "command.context.here"}]}]}, \
    fail_quantity_high: {\
        color: "red", \
        translate: "commands.give.failed.toomanyitems", \
        with: [6400, {interpret: true, nbt:"give.feedback.data.summon", storage: "global:private"}]}, \
    fail_quantity_low: {\
        color: "red", \
        translate: "%s\n%s", \
        with: [\
            {translate: "argument.integer.low", with: [1, {nbt: "give.feedback.data.count", storage: "global:private"}]}, \
            {color: "gray", \
                translate: "... @s %s %s%s", \
                with: [\
                    {nbt: "give.feedback.data.input", storage: "global:private"}, \
                    {color: "red", nbt: "give.feedback.data.count", storage: "global:private", underlined: true}, \
                    {color: "red", italic: true, translate: "command.context.here"}]}]}, \
    success: {\
        translate: "commands.give.success.single", \
        with: [\
            {nbt: "give.feedback.data.count", storage: "global:private"}, \
            {interpret: true, nbt:"give.feedback.data.summon", storage: "global:private"}, \
            {selector: "@s"}]}}

# Check Input
data modify storage global:private give.feedback.data.input set from storage global:private give.output.id
execute if data storage global:private give.output.id run scoreboard players set *pass private.global.give 1

# Check Item
execute if score *pass private.global.give matches 1 \
    run function data_api:command/run_command/from_array {\
        commands: [\
            'function data_api:command/modify_data/convert {nbt: "give.output", return: "item", target: "global:private", type: "storage"}', \
            'data modify storage global:private give.feedback.data.summon.hover_event merge from storage global:private give.output', \
            'execute if data storage global:private give.output.id run scoreboard players set *pass private.global.give 2']}

# Check Integer
execute if score *pass private.global.give matches 2 \
    run function data_api:command/run_command/from_array {\
        commands: [\
            'data modify storage global:private give.feedback.data.count set from storage global:private give.item.count', \
            'data modify storage global:private give.return set from storage global:private give.feedback.data.count', \
            'function data_api:command/modify_data/return {nbt: "give.return", target: "global:private", type: "storage"}', \
            'execute if data storage global:private give{return: "int"} run scoreboard players set *pass private.global.give 3']}

# Check Quantity (too low)
execute if score *pass private.global.give matches 3 \
    run function data_api:command/run_command/from_array {\
        commands: [\
            'execute store result score *count private.global.give run data get storage global:private give.feedback.data.count', \
            'execute if score *count private.global.give matches 1.. run scoreboard players set *pass private.global.give 4']}

# Summon Item
execute if score *pass private.global.give matches 4 \
    run function data_api:command/run_command/from_array {\
        commands: [\
            'summon minecraft:item ~ -100 ~ {Item: {id: "minecraft:stone"}, Tags: ["private.global.item"]}', \
            'data modify entity @n[type=minecraft:item, tag=private.global.item] Item set from storage global:private give.output', \
            'execute as @n[type=minecraft:item, tag=private.global.item, predicate=data_api:tags/rarity/epic] run data modify storage global:private give.feedback.data.summon.color set value "light_purple"', \
            'execute as @n[type=minecraft:item, tag=private.global.item, predicate=data_api:tags/rarity/rare] run data modify storage global:private give.feedback.data.summon.color set value "aqua"', \
            'execute as @n[type=minecraft:item, tag=private.global.item, predicate=data_api:tags/rarity/uncommon] run data modify storage global:private give.feedback.data.summon.color set value "yellow"', \
            'data modify storage global:private give.feedback.data.summon.with[0].hover_event set from storage global:private give.feedback.data.summon.hover_event']}

# Check Quantity (too high)
execute if score *pass private.global.give matches 4 \
    if score *count private.global.give matches ..6400 \
    run scoreboard players set *pass private.global.give 5

# Output Item
execute if score *pass private.global.give matches 5 run function data_api:command/give with storage global:private give

# Send Feedback
execute if score *pass private.global.give matches 0..1 run tellraw @s {interpret: true, nbt: "give.feedback.fail_item", storage: "global:private"}
execute if score *pass private.global.give matches 2 run tellraw @s {interpret: true, nbt: "give.feedback.fail_integer", storage: "global:private"}
execute if score *pass private.global.give matches 3 run tellraw @s {interpret: true, nbt: "give.feedback.fail_quantity_low", storage: "global:private"}
execute if score *pass private.global.give matches 4 run tellraw @s {interpret: true, nbt: "give.feedback.fail_quantity_high", storage: "global:private"}
execute if score *pass private.global.give matches 5 run tellraw @s {interpret: true, nbt: "give.feedback.success", storage: "global:private"}

# Close
kill @e[type=minecraft:item, tag=private.global.item]
scoreboard objectives remove private.global.give
data remove storage global:private give