/*
 * Decompiled with CFR 0.152.
 */
package fr.sukikui.playercoordsapi;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import fr.sukikui.playercoordsapi.PlayerCoordsAPI;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.concurrent.Executors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class PlayerCoordsAPIClient
implements ClientModInitializer {
    private HttpServer server;
    private boolean serverStarted = false;
    private static final int PORT = 25565;

    public void onInitializeClient() {
        if (PlayerCoordsAPI.getConfig().enabled) {
            this.startServer();
        }
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean configEnabled = PlayerCoordsAPI.getConfig().enabled;
            if (configEnabled && !this.serverStarted) {
                this.startServer();
            }
            if (!configEnabled && this.serverStarted) {
                this.stopServer();
            }
        });
        PlayerCoordsAPI.LOGGER.info("Registered config monitor");
    }

    private void startServer() {
        if (this.serverStarted) {
            return;
        }
        try {
            PlayerCoordsAPI.LOGGER.info("Starting PlayerCoordsAPI HTTP server on port 25565");
            this.server = HttpServer.create(new InetSocketAddress(25565), 0);
            this.server.createContext("/api/coords", this::handleCoordsRequest);
            this.server.setExecutor(Executors.newSingleThreadExecutor());
            this.server.start();
            this.serverStarted = true;
            PlayerCoordsAPI.LOGGER.info("PlayerCoordsAPI HTTP server started successfully");
        }
        catch (IOException e) {
            PlayerCoordsAPI.LOGGER.error("Failed to start PlayerCoordsAPI HTTP server", (Throwable)e);
        }
    }

    private void stopServer() {
        if (this.server != null) {
            PlayerCoordsAPI.LOGGER.info("Stopping PlayerCoordsAPI HTTP server");
            HttpServer serverToStop = this.server;
            Thread stopThread = new Thread(() -> {
                serverToStop.stop(0);
                PlayerCoordsAPI.LOGGER.info("PlayerCoordsAPI HTTP server stopped successfully");
            });
            stopThread.setDaemon(true);
            stopThread.start();
            this.server = null;
            this.serverStarted = false;
        }
    }

    private void handleCoordsRequest(HttpExchange exchange) throws IOException {
        if (exchange.getRequestMethod().equalsIgnoreCase("OPTIONS")) {
            this.sendResponse(exchange, 204, null);
            return;
        }
        String remoteAddress = exchange.getRemoteAddress().getAddress().getHostAddress();
        if (!remoteAddress.equals("127.0.0.1") && !remoteAddress.equals("0:0:0:0:0:0:0:1")) {
            this.sendResponse(exchange, 403, "{\"error\": \"Access denied\"}");
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player != null) {
            double x = player.method_23317();
            double y = player.method_23318();
            double z = player.method_23321();
            String world = player.method_37908().method_27983().method_29177().toString();
            class_6880 biomeEntry = player.method_37908().method_23753(player.method_24515());
            String biome = ((class_5321)biomeEntry.method_40230().orElseThrow()).method_29177().toString();
            String uuid = player.method_5667().toString();
            String username = player.method_5477().getString();
            float yaw = player.method_36454();
            float pitch = player.method_36455();
            String responseText = String.format(Locale.US, "{\"x\": %.2f, \"y\": %.2f, \"z\": %.2f, \"yaw\": %.2f, \"pitch\": %.2f, \"world\": \"%s\", \"biome\": \"%s\", \"uuid\": \"%s\", \"username\": \"%s\"}", x, y, z, Float.valueOf(yaw), Float.valueOf(pitch), world, biome, uuid, username);
            this.sendResponse(exchange, 200, responseText);
        } else {
            this.sendResponse(exchange, 404, "{\"error\": \"Player not in world\"}");
        }
    }

    private void sendResponse(HttpExchange exchange, int statusCode, String response) throws IOException {
        exchange.getResponseHeaders().set("Access-Control-Allow-Origin", "*");
        exchange.getResponseHeaders().set("Access-Control-Allow-Methods", "GET, OPTIONS");
        exchange.getResponseHeaders().set("Access-Control-Allow-Headers", "Content-Type, Authorization");
        if (response != null) {
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            exchange.sendResponseHeaders(statusCode, response.length());
            try (OutputStream os = exchange.getResponseBody();){
                os.write(response.getBytes());
            }
        } else {
            exchange.sendResponseHeaders(statusCode, -1L);
        }
    }
}

