/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge;

import com.github.spacemex.enchantmentforge.blocks.entitys.ForgeTableBlockEntity;
import com.github.spacemex.enchantmentforge.commands.TakeExpLevelCommand;
import com.github.spacemex.enchantmentforge.config.CommonConfig;
import com.github.spacemex.enchantmentforge.config.ConfigHelper;
import com.github.spacemex.enchantmentforge.config.ConfigReader;
import com.github.spacemex.enchantmentforge.forgeregistry.BlockRegistry;
import com.github.spacemex.enchantmentforge.forgeregistry.Register;
import com.github.spacemex.enchantmentforge.forgeregistry.ScreenHandlersRegistry;
import com.github.spacemex.enchantmentforge.networking.eventhandler.ConfigSyncHandler;
import com.github.spacemex.enchantmentforge.networking.packets.c2s.OnCraftButtonPressedPacket;
import com.github.spacemex.enchantmentforge.networking.packets.s2c.SendFailMessageToClientsOverlay;
import com.github.spacemex.enchantmentforge.networking.packets.s2c.StartForgeAnimationPacket;
import com.github.spacemex.enchantmentforge.networking.packets.s2c.SyncConfigPacket;
import com.github.spacemex.enchantmentforge.screens.ForgeScreen;
import com.github.spacemex.enchantmentforge.screens.handlers.ForgeScreenHandler;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class Enchantmentforge {
    public static final String MOD_ID = "enchantmentforge";

    public static void init() {
        Register.register();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)OnCraftButtonPressedPacket.ID, (buf, ctx) -> {
            Player patt0$temp = ctx.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                AbstractContainerMenu patt1$temp = player.f_36096_;
                if (patt1$temp instanceof ForgeScreenHandler) {
                    ForgeScreenHandler handler = (ForgeScreenHandler)patt1$temp;
                    ConfigHelper.debug("Server Received OnCraftButtonPressedPacket");
                    ForgeTableBlockEntity entity = handler.getBlockEntity();
                    if (entity != null) {
                        entity.startCraft();
                    }
                }
            }
        });
        CommonConfig.generateConfig(Platform.getConfigFolder().resolve("enchantmentforge/config.yml"));
        ConfigSyncHandler.handle();
        TakeExpLevelCommand.init();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ScreenHandlersRegistry.FORGE_SCREEN_HANDLER.get()), ForgeScreen::new);
        RenderTypeRegistry.register((RenderType)RenderType.m_110457_(), (Block[])new Block[]{(Block)BlockRegistry.FORGE_TABLE_BLOCK.get()});
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)StartForgeAnimationPacket.ID, (buf, ctx) -> ctx.queue(() -> {
            Minecraft client = Minecraft.m_91087_();
            Screen patt0$temp = client.f_91080_;
            if (patt0$temp instanceof ForgeScreen) {
                ForgeScreen screen = (ForgeScreen)patt0$temp;
                ConfigHelper.debug("Client Received StartForgeAnimationPacket");
                screen.startAnimation();
            }
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)SendFailMessageToClientsOverlay.ID, (buf, ctx) -> {
            boolean success = buf.readBoolean();
            String message = buf.m_130136_(Short.MAX_VALUE);
            ctx.queue(() -> {
                Screen patt0$temp;
                Minecraft client = Minecraft.m_91087_();
                if (!success && (patt0$temp = Minecraft.m_91087_().f_91080_) instanceof ForgeScreen) {
                    ForgeScreen screen = (ForgeScreen)patt0$temp;
                    screen.showFailOverlay((Component)Component.m_237113_((String)message), 600);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)SyncConfigPacket.ID, (buf, ctx) -> {
            SyncConfigPacket packet = SyncConfigPacket.decode(buf);
            ConfigReader.setSyncedConfig(packet.getConfig());
        });
    }
}

