/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.blocks.entitys;

import com.github.spacemex.enchantmentforge.config.ConfigHelper;
import com.github.spacemex.enchantmentforge.forgeregistry.EntityTypesRegistry;
import com.github.spacemex.enchantmentforge.forgeregistry.RecipeTypesRegistry;
import com.github.spacemex.enchantmentforge.inventories.ForgeTableInventory;
import com.github.spacemex.enchantmentforge.networking.packets.s2c.StartForgeAnimationPacket;
import com.github.spacemex.enchantmentforge.recipes.ForgeRecipe;
import com.github.spacemex.enchantmentforge.screens.handlers.ForgeScreenHandler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ForgeTableBlockEntity
extends BlockEntity
implements MenuProvider {
    public ForgeTableInventory inventory = new ForgeTableInventory();
    private int progress = 0;
    private int maxProgress = 0;
    private boolean startCraft = false;
    @Nullable
    private UUID lastPlayerId = null;
    @Nullable
    private String lastToolSignature = null;
    private final ContainerData properties = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ForgeTableBlockEntity.this.progress;
                case 1 -> ForgeTableBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
        }

        public int m_6499_() {
            return 2;
        }
    };

    public ForgeTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypesRegistry.FORGE_TABLE_ENTITY_TYPE.get(), pos, state);
        this.inventory.setMarkDirtyCallback(this::onInventoryChanged);
        try {
            this.maxProgress = Math.max(1, this.getConfiguredTotalTickTime());
        }
        catch (Throwable t) {
            this.maxProgress = 200;
        }
    }

    private int getConfiguredTotalTickTime() {
        if (ConfigHelper.isAwaitDrain()) {
            return ConfigHelper.getTotalTickTime() * 2;
        }
        return ConfigHelper.getTotalTickTime();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.enchantmentforge.forge_table");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!this.startCraft) {
                this.lastPlayerId = serverPlayer.m_20148_();
            }
        }
        return new ForgeScreenHandler(syncId, playerInventory, this.inventory, this.properties, this);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, ForgeTableBlockEntity blockEntity) {
        if (world.f_46443_) {
            return;
        }
        if (!blockEntity.startCraft) {
            return;
        }
        if (!blockEntity.hasValidInputs(blockEntity.inventory)) {
            blockEntity.resetProgressIfNeeded();
            ConfigHelper.debug("Invalid Inputs");
            return;
        }
        Optional recipeOpt = world.m_7465_().m_44015_((RecipeType)RecipeTypesRegistry.FORGE_TYPE.get(), (Container)blockEntity.inventory, world);
        if (recipeOpt.isEmpty()) {
            blockEntity.resetProgressIfNeeded();
            ConfigHelper.debug("No Recipe Found");
            return;
        }
        ServerPlayer player = blockEntity.resolveLastPlayer(world);
        if (player == null) {
            blockEntity.resetProgressIfNeeded();
            ConfigHelper.debug("No Player Found");
            return;
        }
        boolean starting = blockEntity.progress == 0;
        ++blockEntity.progress;
        if (starting) {
            ConfigHelper.debug("[Entity]Syncing Animation");
            if (player.f_36096_ instanceof ForgeScreenHandler) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                new StartForgeAnimationPacket().write(buf);
                NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)StartForgeAnimationPacket.ID, (FriendlyByteBuf)buf);
            }
        }
        if (blockEntity.progress >= blockEntity.maxProgress) {
            ForgeRecipe recipe = (ForgeRecipe)recipeOpt.get();
            ItemStack existingToolStack = blockEntity.inventory.m_8020_(0);
            ItemStack result = recipe.craftWithRequirements(blockEntity.inventory, world.m_9598_(), player);
            blockEntity.progress = 0;
            if (!result.m_41619_() && recipe.isSuccess() && player.f_36096_ instanceof ForgeScreenHandler) {
                ((ForgeScreenHandler)player.f_36096_).craftSound(true);
            }
            if (!ItemStack.m_41728_((ItemStack)existingToolStack, (ItemStack)result)) {
                blockEntity.lastToolSignature = blockEntity.computeToolSignature();
            }
            blockEntity.m_6596_();
            blockEntity.startCraft = false;
        }
    }

    public void startCraft() {
        if (this.startCraft) {
            ConfigHelper.debug("Already Starting Craft");
        } else {
            ConfigHelper.debug("Setting Start Craft");
            this.startCraft = true;
        }
    }

    private boolean hasValidInputs(Container inv) {
        return !inv.m_8020_(0).m_41619_() && !inv.m_8020_(1).m_41619_() && !inv.m_8020_(2).m_41619_();
    }

    private void resetProgressIfNeeded() {
        if (this.progress != 0) {
            this.progress = 0;
        }
        if (this.startCraft) {
            this.startCraft = false;
        }
        this.m_6596_();
    }

    @Nullable
    private ServerPlayer resolveLastPlayer(Level world) {
        if (!(world instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        if (this.lastPlayerId == null) {
            return null;
        }
        return serverWorld.m_7654_().m_6846_().m_11259_(this.lastPlayerId);
    }

    private String computeToolSignature() {
        ItemStack tool = this.inventory.m_8020_(0);
        if (tool.m_41619_()) {
            return "empty";
        }
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)tool.m_41720_());
        String nbt = tool.m_41783_() == null ? "" : tool.m_41783_().toString();
        return String.valueOf(id) + "|" + tool.m_41613_() + "|" + nbt;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void onInventoryChanged() {
        ConfigHelper.debug("Checking Inventory");
        String currentSig = this.computeToolSignature();
        if (!Objects.equals(currentSig, this.lastToolSignature)) {
            this.lastToolSignature = currentSig;
            this.progress = 0;
            ConfigHelper.debug("Tool Changed");
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public ContainerData getProperties() {
        return this.properties;
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.inventory.writeNbt(nbt);
        nbt.m_128405_("Progress", this.progress);
        nbt.m_128405_("MaxProgress", this.maxProgress);
        nbt.m_128379_("StartCraft", this.startCraft);
        if (this.lastToolSignature != null) {
            nbt.m_128359_("LastToolSig", this.lastToolSignature);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.readNbt(nbt);
        this.progress = nbt.m_128451_("Progress");
        this.maxProgress = Math.max(1, nbt.m_128441_("MaxProgress") ? nbt.m_128451_("MaxProgress") : this.maxProgress);
        this.startCraft = nbt.m_128471_("StartCraft");
        this.lastToolSignature = nbt.m_128441_("LastToolSig") ? nbt.m_128461_("LastToolSig") : null;
    }
}

