/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.recipes;

import com.github.spacemex.enchantmentforge.config.ConfigHelper;
import com.github.spacemex.enchantmentforge.forgeregistry.RecipeSerializersRegistry;
import com.github.spacemex.enchantmentforge.forgeregistry.RecipeTypesRegistry;
import com.github.spacemex.enchantmentforge.inventories.ForgeTableInventory;
import com.github.spacemex.enchantmentforge.networking.packets.s2c.SendFailMessageToClientsOverlay;
import com.github.spacemex.enchantmentforge.recipes.requirements.ExpLevelsRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.ExpPointsRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.HasEnchantmentRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.data.Requirement;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class ForgeRecipe
implements Recipe<ForgeTableInventory> {
    private boolean success;
    private final ResourceLocation id;
    private final Ingredient tool;
    private final Ingredient fuel;
    public final Map<String, GemEnchantData> gemsToEnchantment;

    public ForgeRecipe(ResourceLocation id, Ingredient tool, Ingredient fuel, Map<String, GemEnchantData> gemsToEnchantment) {
        this.id = id;
        this.tool = tool;
        this.fuel = fuel;
        this.gemsToEnchantment = gemsToEnchantment;
        this.success = false;
    }

    public boolean matches(ForgeTableInventory inventory, Level world) {
        if (inventory.m_6643_() < 3) {
            return false;
        }
        ItemStack toolStack = inventory.m_8020_(0);
        ItemStack gemStack = inventory.m_8020_(1);
        ItemStack fuelStack = inventory.m_8020_(2);
        if (!this.tool.test(toolStack)) {
            return false;
        }
        if (!this.fuel.test(fuelStack)) {
            return false;
        }
        GemEnchantData data = this.resolveGemData(gemStack);
        if (data == null) {
            return false;
        }
        Enchantment enchant = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(data.enchantmentId());
        if (enchant == null) {
            return false;
        }
        int currentLevel = EnchantmentHelper.m_44843_((Enchantment)enchant, (ItemStack)toolStack);
        int nextLevel = ForgeRecipe.nextLevelAbove(currentLevel, data.levelMap());
        return currentLevel < enchant.m_6586_() && nextLevel > 0;
    }

    private static void sendCraftFail(ServerPlayer player, String message) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeBoolean(false);
        buf.m_130070_(message);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)SendFailMessageToClientsOverlay.ID, (FriendlyByteBuf)buf);
    }

    private static String failMessageFor(Requirement req, ServerPlayer player, ItemStack tool) {
        if (req instanceof ExpLevelsRequirement) {
            ExpLevelsRequirement elr = (ExpLevelsRequirement)req;
            return "Need level " + elr.minLevel;
        }
        if (req instanceof ExpPointsRequirement) {
            ExpPointsRequirement epr = (ExpPointsRequirement)req;
            return "Need " + epr.minPoints + " XP points";
        }
        if (req instanceof HasEnchantmentRequirement) {
            HasEnchantmentRequirement her = (HasEnchantmentRequirement)req;
            Enchantment ench = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(her.enchantId);
            if (ench != null) {
                String name = ench.m_44700_(her.minLevel).getString();
                return "Requires " + name;
            }
            return "Requires " + her.enchantId.m_135815_() + " lvl " + her.minLevel;
        }
        return "A requirement was not met.";
    }

    private GemEnchantData resolveGemData(ItemStack gemStack) {
        ResourceLocation gemId = BuiltInRegistries.f_257033_.m_7981_((Object)gemStack.m_41720_());
        GemEnchantData direct = this.gemsToEnchantment.get(gemId.toString());
        if (direct != null) {
            return direct;
        }
        for (Map.Entry<String, GemEnchantData> e : this.gemsToEnchantment.entrySet()) {
            TagKey tag;
            ResourceLocation tagId;
            String key = e.getKey();
            if (!key.startsWith("#") || (tagId = ResourceLocation.m_135820_((String)key.substring(1))) == null || !gemStack.m_204117_(tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId))) continue;
            return e.getValue();
        }
        return null;
    }

    private static int nextLevelAbove(int current, List<Integer> levels) {
        for (int lvl : levels) {
            if (lvl <= current) continue;
            return lvl;
        }
        return -1;
    }

    public ItemStack craftWithRequirements(Container inventory, RegistryAccess registryManager, ServerPlayer player) {
        ResourceLocation tagId;
        this.success = false;
        ItemStack toolStack = inventory.m_8020_(0);
        ItemStack gemStack = inventory.m_8020_(1);
        ItemStack fuelStack = inventory.m_8020_(2);
        if (toolStack.m_41619_() || gemStack.m_41619_() || fuelStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ResourceLocation gemId = BuiltInRegistries.f_257033_.m_7981_((Object)gemStack.m_41720_());
        String gemKey = gemId.toString();
        GemEnchantData data = this.gemsToEnchantment.get(gemKey);
        if (data == null) {
            for (Map.Entry<String, GemEnchantData> entry : this.gemsToEnchantment.entrySet()) {
                TagKey tag;
                String key = entry.getKey();
                if (!key.startsWith("#") || !gemStack.m_204117_(tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)(tagId = new ResourceLocation(key.substring(1)))))) continue;
                data = entry.getValue();
                break;
            }
        }
        if (data == null) {
            return toolStack;
        }
        Enchantment enchant = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(data.enchantmentId);
        if (enchant == null) {
            return toolStack;
        }
        int currentLevel = EnchantmentHelper.m_44843_((Enchantment)enchant, (ItemStack)toolStack);
        if (currentLevel == enchant.m_6586_()) {
            return toolStack;
        }
        if (currentLevel <= 0) {
            try {
                currentLevel = EnchantmentHelper.m_182438_((CompoundTag)Objects.requireNonNull(toolStack.m_41783_()));
            }
            catch (Exception key) {
                // empty catch block
            }
        }
        int nextLevel = -1;
        tagId = data.levelMap.iterator();
        while (tagId.hasNext()) {
            int lvl = (Integer)tagId.next();
            if (lvl <= currentLevel) continue;
            nextLevel = lvl;
            break;
        }
        if (nextLevel <= 0) {
            return toolStack;
        }
        int requiredFuel = data.costModifierPerLevel().getOrDefault(nextLevel, Integer.MAX_VALUE);
        if (fuelStack.m_41613_() < requiredFuel) {
            ForgeRecipe.sendCraftFail(player, "Insufficient Fuel");
            return toolStack;
        }
        List requirements = data.requirementsPerLevel().getOrDefault(nextLevel, Collections.emptyList());
        boolean requirementsMet = true;
        if (!requirements.isEmpty()) {
            for (Requirement requirement : requirements) {
                if (requirement.check(player, toolStack)) {
                    ConfigHelper.debug("Successfully Met Requirement");
                    requirement.onSuccess(player);
                    continue;
                }
                ForgeRecipe.sendCraftFail(player, ForgeRecipe.failMessageFor(requirement, player, toolStack));
                requirement.onFail(player);
                requirementsMet = false;
                break;
            }
        }
        if (!requirementsMet) {
            this.success = false;
            return toolStack;
        }
        ItemStack result = toolStack.m_41777_();
        Map existingEnchants = EnchantmentHelper.m_44831_((ItemStack)result);
        existingEnchants.put(enchant, nextLevel);
        EnchantmentHelper.m_44865_((Map)existingEnchants, (ItemStack)result);
        fuelStack.m_41774_(requiredFuel);
        gemStack.m_41774_(1);
        inventory.m_6836_(0, result);
        inventory.m_6836_(1, gemStack);
        inventory.m_6836_(2, fuelStack);
        this.success = true;
        return result;
    }

    public ItemStack craft(ForgeTableInventory inventory, RegistryAccess registryManager) {
        return ItemStack.f_41583_;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public Ingredient getFuel() {
        return this.fuel;
    }

    public Map<String, GemEnchantData> getGemEnchantments() {
        return this.gemsToEnchantment;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializersRegistry.FORGE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypesRegistry.FORGE_TYPE.get();
    }

    public record GemEnchantData(ResourceLocation enchantmentId, List<Integer> levelMap, Map<Integer, Integer> costModifierPerLevel, Map<Integer, List<Requirement>> requirementsPerLevel) {
    }

    public static class Serializer
    implements RecipeSerializer<ForgeRecipe> {
        public ForgeRecipe read(ResourceLocation id, JsonObject json) {
            Ingredient tool = Ingredient.m_43917_((JsonElement)json.get("tool"));
            Ingredient fuel = Ingredient.m_43917_((JsonElement)json.get("fuel"));
            JsonObject gemObject = json.getAsJsonObject("gems_to_enchantment");
            HashMap<String, GemEnchantData> map = new HashMap<String, GemEnchantData>();
            for (Map.Entry entry : gemObject.entrySet()) {
                String gemId = (String)entry.getKey();
                JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
                ResourceLocation enchantId = new ResourceLocation(data.get("enchantment").getAsString());
                ArrayList<Integer> levelMap = new ArrayList<Integer>();
                for (JsonElement e : data.getAsJsonArray("level_map")) {
                    levelMap.add(e.getAsInt());
                }
                HashMap<Integer, Integer> costs = new HashMap<Integer, Integer>();
                JsonObject costsJson = data.getAsJsonObject("cost_modifier_per_level");
                for (Map.Entry c : costsJson.entrySet()) {
                    costs.put(Integer.parseInt((String)c.getKey()), ((JsonElement)c.getValue()).getAsInt());
                }
                HashMap<Integer, List<Requirement>> requirementsPerLevel = new HashMap<Integer, List<Requirement>>();
                if (data.has("requirements")) {
                    for (JsonElement reqElement : data.getAsJsonArray("requirements")) {
                        JsonObject reqObj = reqElement.getAsJsonObject();
                        for (Map.Entry reqEntry : reqObj.entrySet()) {
                            int level = Integer.parseInt((String)reqEntry.getKey());
                            JsonObject reqData = ((JsonElement)reqEntry.getValue()).getAsJsonObject();
                            Requirement req = Requirement.fromJson(reqData);
                            requirementsPerLevel.computeIfAbsent(level, k -> new ArrayList()).add(req);
                        }
                    }
                }
                map.put(gemId, new GemEnchantData(enchantId, levelMap, costs, requirementsPerLevel));
            }
            return new ForgeRecipe(id, tool, fuel, map);
        }

        public ForgeRecipe read(ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient tool = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient fuel = Ingredient.m_43940_((FriendlyByteBuf)buf);
            int gemCount = buf.m_130242_();
            HashMap<String, GemEnchantData> map = new HashMap<String, GemEnchantData>();
            for (int i = 0; i < gemCount; ++i) {
                String gemId = buf.m_130277_();
                ResourceLocation enchantId = buf.m_130281_();
                int levelCount = buf.m_130242_();
                ArrayList<Integer> levelMap = new ArrayList<Integer>(levelCount);
                for (int j = 0; j < levelCount; ++j) {
                    levelMap.add(buf.m_130242_());
                }
                int costCount = buf.m_130242_();
                HashMap<Integer, Integer> costs = new HashMap<Integer, Integer>(costCount);
                for (int j = 0; j < costCount; ++j) {
                    int level = buf.m_130242_();
                    int cost = buf.m_130242_();
                    costs.put(level, cost);
                }
                int reqLevels = buf.m_130242_();
                HashMap<Integer, List<Requirement>> requirementsPerLevel = new HashMap<Integer, List<Requirement>>(reqLevels);
                for (int r = 0; r < reqLevels; ++r) {
                    int lvlKey = buf.m_130242_();
                    int reqCount = buf.m_130242_();
                    ArrayList<Requirement> reqList = new ArrayList<Requirement>(reqCount);
                    for (int q = 0; q < reqCount; ++q) {
                        reqList.add(Requirement.read(buf));
                    }
                    requirementsPerLevel.put(lvlKey, reqList);
                }
                map.put(gemId, new GemEnchantData(enchantId, levelMap, costs, requirementsPerLevel));
            }
            return new ForgeRecipe(id, tool, fuel, map);
        }

        public void write(FriendlyByteBuf buf, ForgeRecipe recipe) {
            recipe.tool.m_43923_(buf);
            recipe.fuel.m_43923_(buf);
            buf.m_130130_(recipe.gemsToEnchantment.size());
            for (Map.Entry<String, GemEnchantData> entry : recipe.gemsToEnchantment.entrySet()) {
                buf.m_130070_(entry.getKey());
                GemEnchantData data = entry.getValue();
                buf.m_130085_(data.enchantmentId());
                buf.m_130130_(data.levelMap().size());
                Iterator<Object> iterator = data.levelMap().iterator();
                while (iterator.hasNext()) {
                    int n = iterator.next();
                    buf.m_130130_(n);
                }
                buf.m_130130_(data.costModifierPerLevel().size());
                for (Map.Entry entry2 : data.costModifierPerLevel().entrySet()) {
                    buf.m_130130_(((Integer)entry2.getKey()).intValue());
                    buf.m_130130_(((Integer)entry2.getValue()).intValue());
                }
                Map<Integer, List<Requirement>> reqs = data.requirementsPerLevel();
                buf.m_130130_(reqs.size());
                for (Map.Entry<Integer, List<Requirement>> reqEntry : reqs.entrySet()) {
                    buf.m_130130_(reqEntry.getKey().intValue());
                    List<Requirement> list = reqEntry.getValue();
                    buf.m_130130_(list.size());
                    for (Requirement req : list) {
                        Requirement.write(buf, req);
                    }
                }
            }
        }
    }
}

