/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.recipes.requirements;

import com.github.spacemex.enchantmentforge.recipes.requirements.data.ActionData;
import com.github.spacemex.enchantmentforge.recipes.requirements.data.Requirement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ExpLevelsRequirement
implements Requirement {
    public final int minLevel;
    private final ActionData failAction;
    private final ActionData successAction;

    public ExpLevelsRequirement(JsonObject json) {
        this.minLevel = json.has("level") ? json.get("level").getAsInt() : 0;
        this.failAction = json.has("fail") ? new ActionData(json.getAsJsonObject("fail")) : new ActionData(new JsonObject());
        this.successAction = json.has("success") ? new ActionData(json.getAsJsonObject("success")) : new ActionData(new JsonObject());
    }

    @Override
    public boolean check(ServerPlayer player, ItemStack itemStack) {
        return player.f_36078_ >= this.minLevel;
    }

    @Override
    public void onFail(ServerPlayer player) {
        this.failAction.execute(player);
    }

    @Override
    public void onSuccess(ServerPlayer player) {
        this.successAction.execute(player);
    }

    public static ExpLevelsRequirement read(FriendlyByteBuf buf) {
        int lvl = buf.m_130242_();
        ActionData fail = ActionData.read(buf);
        ActionData success = ActionData.read(buf);
        return new ExpLevelsRequirement(lvl, fail, success);
    }

    public static void write(FriendlyByteBuf buf, ExpLevelsRequirement req) {
        buf.m_130130_(req.minLevel);
        ActionData.write(buf, req.failAction);
        ActionData.write(buf, req.successAction);
    }

    private ExpLevelsRequirement(int minLevel, ActionData failAction, ActionData successAction) {
        JsonObject tmp = new JsonObject();
        this.minLevel = minLevel;
        this.failAction = failAction;
        this.successAction = successAction;
    }
}

