/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.recipes.requirements;

import com.github.spacemex.enchantmentforge.recipes.requirements.data.ActionData;
import com.github.spacemex.enchantmentforge.recipes.requirements.data.Requirement;
import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class HasEnchantmentRequirement
implements Requirement {
    public final ResourceLocation enchantId;
    public final int minLevel;
    private final ActionData failAction;
    private final ActionData successAction;

    public HasEnchantmentRequirement(JsonObject json) {
        this.enchantId = new ResourceLocation(json.get("enchantment").getAsString());
        this.minLevel = json.has("min_level") ? json.get("min_level").getAsInt() : 1;
        this.failAction = json.has("fail") ? new ActionData(json.getAsJsonObject("fail")) : new ActionData(new JsonObject());
        this.successAction = json.has("success") ? new ActionData(json.getAsJsonObject("success")) : new ActionData(new JsonObject());
    }

    @Override
    public boolean check(ServerPlayer player, ItemStack tool) {
        Enchantment enchant = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(this.enchantId);
        if (enchant == null) {
            return false;
        }
        int lvl = EnchantmentHelper.m_44843_((Enchantment)enchant, (ItemStack)tool);
        return lvl >= this.minLevel;
    }

    @Override
    public void onFail(ServerPlayer player) {
        this.failAction.execute(player);
    }

    @Override
    public void onSuccess(ServerPlayer player) {
        this.successAction.execute(player);
    }

    public static HasEnchantmentRequirement read(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        int min = buf.m_130242_();
        ActionData fail = ActionData.read(buf);
        ActionData success = ActionData.read(buf);
        return new HasEnchantmentRequirement(id, min, fail, success);
    }

    public static void write(FriendlyByteBuf buf, HasEnchantmentRequirement req) {
        buf.m_130085_(req.enchantId);
        buf.m_130130_(req.minLevel);
        ActionData.write(buf, req.failAction);
        ActionData.write(buf, req.successAction);
    }

    private HasEnchantmentRequirement(ResourceLocation id, int minLevel, ActionData fail, ActionData success) {
        JsonObject tmp = new JsonObject();
        this.enchantId = id;
        this.minLevel = minLevel;
        this.failAction = fail;
        this.successAction = success;
    }
}

