/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.recipes.requirements.data;

import com.github.spacemex.enchantmentforge.config.ConfigHelper;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class ActionData {
    private final String message;
    private final String messageType;
    private final List<String> commands;
    private ResourceLocation soundId;
    private float volume;
    private float pitch;

    public ActionData(JsonObject json) {
        this.message = json.has("message") ? json.get("message").getAsString() : "";
        this.messageType = json.has("message-type") ? json.get("message-type").getAsString() : "CHAT";
        this.commands = new ArrayList<String>();
        if (json.has("commands")) {
            json.getAsJsonArray("commands").forEach(e -> this.commands.add(e.getAsString()));
        }
        if (json.has("sound")) {
            ConfigHelper.debug("Action Data Has Custom Sound");
            JsonObject s = json.getAsJsonObject("sound");
            if (s.has("volume")) {
                ConfigHelper.debug("Action Data Has Custom Volume");
            } else {
                ConfigHelper.debug("Action Data Has No Volume Defaulting To 1");
            }
            if (s.has("pitch")) {
                ConfigHelper.debug("Action Data Has Custom Pitch");
            } else {
                ConfigHelper.debug("Action Data Has No Pitch Defaulting To 1");
            }
            this.soundId = ResourceLocation.m_135820_((String)s.get("type").getAsString());
            this.volume = s.has("volume") ? s.get("volume").getAsFloat() : 1.0f;
            float f = this.pitch = s.has("pitch") ? s.get("pitch").getAsFloat() : 1.0f;
            if (this.soundId.toString().isEmpty() || Objects.equals(this.soundId.toString(), "")) {
                this.soundId = null;
                this.volume = 1.0f;
                this.pitch = 1.0f;
            }
        } else {
            ConfigHelper.debug("Action Data Has No Custom Sound");
            this.soundId = null;
            this.volume = 1.0f;
            this.pitch = 1.0f;
        }
        if (!this.message.isEmpty()) {
            ConfigHelper.debug("Action Data Has Message : " + this.message);
        } else {
            ConfigHelper.debug("Action Data Has No Message : " + this.message);
        }
        if (!this.commands.isEmpty()) {
            ConfigHelper.debug("Action Data Has Commands : " + String.valueOf(this.commands));
        } else {
            ConfigHelper.debug("Action Data Has No Commands : " + String.valueOf(this.commands));
        }
    }

    public static ActionData read(FriendlyByteBuf buf) {
        String message = buf.m_130136_(Short.MAX_VALUE);
        String messageType = buf.m_130136_(Short.MAX_VALUE);
        int cmdCount = buf.m_130242_();
        ArrayList<String> commands = new ArrayList<String>(cmdCount);
        for (int i = 0; i < cmdCount; ++i) {
            commands.add(buf.m_130136_(Short.MAX_VALUE));
        }
        boolean hasSound = buf.readBoolean();
        ResourceLocation soundId = null;
        float volume = 1.0f;
        float pitch = 1.0f;
        if (hasSound) {
            soundId = buf.m_130281_();
            volume = buf.readFloat();
            pitch = buf.readFloat();
        }
        JsonObject tmp = new JsonObject();
        tmp.addProperty("message", message);
        tmp.addProperty("message-type", messageType);
        ActionData action = new ActionData(tmp);
        action.commands.clear();
        action.commands.addAll(commands);
        return new ActionData(message, messageType, commands, soundId, volume, pitch);
    }

    private ActionData(String message, String messageType, List<String> commands, ResourceLocation soundId, float volume, float pitch) {
        this.message = message;
        this.messageType = messageType;
        this.commands = new ArrayList<String>(commands);
        this.soundId = soundId;
        this.volume = volume;
        this.pitch = pitch;
    }

    public void execute(ServerPlayer player) {
        if (this.message != null && !this.message.isEmpty()) {
            ConfigHelper.debug("Executing Custom Message : " + this.message + " with Type : " + this.messageType);
            boolean actionBar = "ACTION".equalsIgnoreCase(this.messageType);
            player.m_240418_(Component.m_130674_((String)this.message), actionBar);
        }
        if (!this.commands.isEmpty() && player.m_20194_() != null) {
            ConfigHelper.debug("Executing Custom Commands");
            MinecraftServer server = player.m_20194_();
            CommandSourceStack silentSource = server.m_129893_().m_165484_(CommandSource.f_80164_).m_81324_();
            for (String cmd : this.commands) {
                String parsed = cmd.replace("%player%", player.m_6302_()).replace("%player_coords%", player.m_20183_().m_123341_() + " " + player.m_20183_().m_123342_() + " " + player.m_20183_().m_123343_());
                ConfigHelper.debug("Parsed Command " + parsed);
                try {
                    ConfigHelper.debug("Executing Command: " + parsed);
                    server.m_129892_().m_230957_(silentSource, parsed);
                }
                catch (Exception e) {
                    ConfigHelper.debug("Saved You From A Crash :p");
                    ConfigHelper.debug("Failed to execute Command: " + parsed);
                }
            }
        }
        if (this.soundId != null || this.soundId.toString().isEmpty()) {
            ConfigHelper.debug("Executing Custom Sound With ID: " + String.valueOf(this.soundId));
            SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(this.soundId);
            if (soundEvent != null) {
                player.m_9236_().m_5594_(null, player.m_20183_(), soundEvent, SoundSource.PLAYERS, this.volume, this.pitch);
            }
        }
    }

    public static void write(FriendlyByteBuf buf, ActionData action) {
        buf.m_130070_(action.message == null ? "" : action.message);
        buf.m_130070_(action.messageType == null ? "" : action.messageType);
        buf.m_130130_(action.commands.size());
        for (String c : action.commands) {
            buf.m_130070_(c);
        }
        buf.writeBoolean(action.soundId != null);
        if (action.soundId != null) {
            buf.m_130085_(action.soundId);
            buf.writeFloat(action.volume);
            buf.writeFloat(action.pitch);
        }
    }
}

