/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.screens;

import com.github.spacemex.enchantmentforge.config.ConfigHelper;
import com.github.spacemex.enchantmentforge.forgeregistry.RecipeTypesRegistry;
import com.github.spacemex.enchantmentforge.inventories.ForgeTableInventory;
import com.github.spacemex.enchantmentforge.networking.packets.c2s.OnCraftButtonPressedPacket;
import com.github.spacemex.enchantmentforge.recipes.ForgeRecipe;
import com.github.spacemex.enchantmentforge.recipes.requirements.ExpLevelsRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.ExpPointsRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.HasEnchantmentRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.data.Requirement;
import com.github.spacemex.enchantmentforge.screens.handlers.ForgeScreenHandler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ForgeScreen
extends AbstractContainerScreen<ForgeScreenHandler> {
    private static final ResourceLocation GUI = ResourceLocation.m_214293_((String)"enchantmentforge", (String)"textures/gui/forge_table_gui.png");
    Button craftButton;
    private boolean isFinished = true;
    private boolean animating = false;
    private float arrowR;
    private float arrowL;
    private float arrowM = 0.0f;
    private int rightTick = 15;
    private int leftTick = 15;
    private int middleTick = 15;
    private int animationCounter;
    private int phase;
    private int scrollOffset = 0;
    private final List<FormattedCharSequence> requirementLines = new ArrayList<FormattedCharSequence>();
    private final int textBoxWidth = 72;
    private final int textBoxHeight = 110;
    private final int lineHeight = 10;
    private ItemStack hoveredStack = ItemStack.f_41583_;
    private Component lastFailMsg = null;
    private int lastFailTimer = 0;

    public ForgeScreen(ForgeScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_97726_ = 234;
        this.f_97727_ = 166;
    }

    private ForgeScreenHandler getHandler() {
        return (ForgeScreenHandler)this.f_97732_;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.f_97735_ + 62;
        int y = this.f_97736_ + 53;
        this.craftButton = (Button)this.m_142416_((GuiEventListener)new CraftButtonWidget(x, y, GUI, button -> this.onButtonPress()));
    }

    protected void m_7286_(GuiGraphics context, float delta, int mouseX, int mouseY) {
        this.f_97726_ = 253;
        this.renderGui(context);
        this.renderTooltipOverlay(context, mouseX, mouseY);
        this.renderArrows(context);
    }

    protected void m_181908_() {
        super.m_181908_();
        if (this.lastFailTimer > 0) {
            --this.lastFailTimer;
        }
        this.setToolTipOverlayValues();
        this.syncArrowsFromServerProgress();
    }

    private void syncArrowsFromServerProgress() {
        int serverProgress = this.getHandler().getServerProgress();
        int serverMax = this.getHandler().getServerMaxProgress();
        boolean awaitDrain = ConfigHelper.isAwaitDrain();
        if (serverMax <= 0) {
            this.animating = false;
            this.arrowL = 0.0f;
            this.arrowM = 0.0f;
            this.arrowR = 0.0f;
            this.phase = 0;
            this.animationCounter = 0;
            return;
        }
        this.setArrowTickSpeed();
        int rT = Math.max(1, this.rightTick);
        int mT = Math.max(1, this.middleTick);
        int lT = Math.max(1, this.leftTick);
        int localTotal = rT + mT + lT;
        int p = awaitDrain ? ForgeScreen.mapTriangle(serverProgress, serverMax, localTotal) : ForgeScreen.mapLinear(serverProgress, serverMax, localTotal);
        int segR = Math.min(p, rT);
        int segM = Math.max(0, Math.min(p - rT, mT));
        int segL = Math.max(0, Math.min(p - rT - mT, lT));
        if (p <= rT) {
            this.phase = 0;
            this.animationCounter = segR;
            this.arrowR = (float)segR / (float)rT;
            this.arrowM = 0.0f;
            this.arrowL = 0.0f;
        } else if (p <= rT + mT) {
            this.phase = 1;
            this.animationCounter = segM;
            this.arrowR = 1.0f;
            this.arrowM = (float)segM / (float)mT;
            this.arrowL = 0.0f;
        } else {
            this.phase = 2;
            this.animationCounter = segL;
            this.arrowR = 1.0f;
            this.arrowM = 1.0f;
            this.arrowL = (float)segL / (float)lT;
        }
        this.animating = serverProgress > 0 && serverProgress < serverMax;
        this.isFinished = !this.animating;
    }

    private static int mapLinear(int serverProgress, int serverMax, int localTotal) {
        if (serverMax <= 0) {
            return 0;
        }
        double lin = Math.max(0.0, Math.min(1.0, (double)serverProgress / (double)serverMax));
        return (int)Math.round(lin * (double)localTotal);
    }

    private static int mapTriangle(int serverProgress, int serverMax, int localTotal) {
        if (serverMax <= 0) {
            return 0;
        }
        double half = (double)serverMax / 2.0;
        double tri = (double)serverProgress <= half ? (double)serverProgress : (double)(serverMax - serverProgress);
        tri = Math.max(0.0, Math.min(half, tri));
        double lin = half <= 0.0 ? 0.0 : tri / half;
        return (int)Math.round(lin * (double)localTotal);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, delta);
        this.m_280072_(context, mouseX, mouseY);
        if (!this.hoveredStack.m_41619_()) {
            context.m_280666_(this.f_96547_, this.hoveredStack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)), mouseX, mouseY);
            this.hoveredStack = ItemStack.f_41583_;
        }
    }

    protected void m_280003_(GuiGraphics context, int mouseX, int mouseY) {
        context.m_280649_(this.f_96547_, this.f_96539_.m_7532_(), this.f_97735_ / 2, 6, 0x404040, false);
        context.m_280614_(this.f_96547_, this.f_169604_, this.f_97735_ / this.f_97730_ + 15, this.f_97731_, 0x404040, false);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        int maxScroll = Math.max(0, this.requirementLines.size() * 10 - 110);
        this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.scrollOffset - amount * 10.0, (double)maxScroll));
        return true;
    }

    private void setArrowTickSpeed() {
        this.rightTick = ConfigHelper.getRightTick();
        this.leftTick = ConfigHelper.getLeftTick();
        this.middleTick = ConfigHelper.getMiddleTick();
    }

    private void onButtonPress() {
        if (this.animating) {
            return;
        }
        CraftButtonWidget button = (CraftButtonWidget)this.craftButton;
        button.setPressed(true);
        ConfigHelper.debug("Craft Button Pressed, Sending Packet to Server");
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        NetworkManager.sendToServer((ResourceLocation)OnCraftButtonPressedPacket.ID, (FriendlyByteBuf)buf);
    }

    private void renderGui(GuiGraphics context) {
        int x = this.f_97735_;
        int y = this.f_97736_;
        context.m_280163_(GUI, x, y, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
    }

    private void renderTooltipOverlay(GuiGraphics context, int mouseX, int mouseY) {
        int x = this.f_97735_ + 175;
        int y = this.f_97736_ + 23;
        int p = 4;
        context.m_280509_(x, y, x + 72, y + 110, -2013265920);
        context.m_280588_(x, y, x + 72, y + 110);
        int currentY = y - this.scrollOffset;
        if (this.lastFailTimer > 0 && this.lastFailMsg != null && this.isFinished) {
            int avail = 72 - p * 2;
            List lines = this.f_96547_.m_92923_((FormattedText)this.lastFailMsg, avail);
            int lh = this.lineHeight;
            int padV = 2;
            int h = padV * 2 + lines.size() * lh;
            int bgTop = currentY + 2;
            int bgBottom = bgTop + h;
            context.m_280509_(x + 2, bgTop, x + 72 - 2, bgBottom, -1437270016);
            int ty = bgTop + padV;
            for (FormattedCharSequence line : lines) {
                if (ty + lh >= y && ty <= y + 110) {
                    context.m_280649_(this.f_96547_, line, x + p, ty, -43691, false);
                }
                ty += lh;
            }
            currentY = bgBottom + 3;
            ConfigHelper.debug("Showing Tooltip Overlay for last fail msg");
        }
        List<Object> reqs = this.getRequirementEntries();
        for (Object entry : reqs) {
            int iconY;
            int iconX;
            if (entry instanceof String) {
                String str = (String)entry;
                for (FormattedCharSequence line : this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)str), 72 - p * 2)) {
                    if (currentY + 10 >= y && currentY <= y + 110) {
                        context.m_280649_(this.f_96547_, line, x + p, currentY + 2, 0xFFFFFF, false);
                    }
                    currentY += 10;
                }
                continue;
            }
            if (!(entry instanceof ItemStack)) continue;
            ItemStack stack = (ItemStack)entry;
            String label = "Enchant:";
            int labelWidth = this.f_96547_.m_92895_(label);
            int availableWidth = 72 - p * 2;
            if (currentY + 10 >= y && currentY <= y + 110) {
                context.m_280056_(this.f_96547_, label, x + p, currentY + 4, 0xFFFFFF, false);
            }
            if (labelWidth + 4 + 16 <= availableWidth) {
                iconX = x + p + labelWidth + 4;
                iconY = currentY;
                currentY += 18;
            } else {
                iconX = x + 28;
                iconY = currentY += 10;
                currentY += 18;
            }
            if (iconY + 16 < y || iconY > y + 110) continue;
            context.m_280480_(stack, iconX, iconY);
            context.m_280370_(this.f_96547_, stack, iconX, iconY);
            if (mouseX < iconX || mouseX >= iconX + 16 || mouseY < iconY || mouseY >= iconY + 16) continue;
            this.hoveredStack = stack;
        }
        context.m_280618_();
    }

    private void renderArrows(GuiGraphics context) {
        int leftU = 183;
        int LeftV = 228;
        int LeftWidth = 12;
        int LeftHeight = 25;
        int LeftX = this.f_97735_ + 50;
        int LeftY = this.f_97736_ + 20;
        int rightU = 242;
        int rightV = 228;
        int rightW = 13;
        int rightH = 25;
        int rightX = this.f_97735_ + 109;
        int rightY = this.f_97736_ + 20;
        int middleU = 212;
        int middleV = 245;
        int middleW = 16;
        int middleH = 11;
        int middleX = this.f_97735_ + 79;
        int middleY = this.f_97736_ + 37;
        if (this.arrowL > 0.0f) {
            int leftFilled = (int)(this.arrowL * (float)LeftHeight);
            context.m_280163_(GUI, LeftX, LeftY + (LeftHeight - leftFilled), (float)leftU, (float)(LeftV + (LeftHeight - leftFilled)), LeftWidth, leftFilled, 256, 256);
        }
        if (this.arrowR > 0.0f) {
            int rightFilled = (int)(this.arrowR * (float)rightH);
            context.m_280163_(GUI, rightX, rightY, (float)rightU, (float)rightV, rightW, rightFilled, 256, 256);
        }
        if (this.arrowM > 0.0f) {
            int middleFilled = (int)(this.arrowM * (float)middleW);
            context.m_280163_(GUI, middleX + (middleW - middleFilled), middleY, (float)(middleU + (middleW - middleFilled)), (float)middleV, middleFilled, middleH, 256, 256);
        }
    }

    private void setToolTipOverlayValues() {
        List<Object> reqs = this.getRequirementEntries();
        this.requirementLines.clear();
        for (Object entry : reqs) {
            if (!(entry instanceof String)) continue;
            String str = (String)entry;
            this.requirementLines.addAll(this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)str), 66));
        }
    }

    private List<Object> getRequirementEntries() {
        ArrayList<Object> entries = new ArrayList<Object>();
        if (!(((ForgeScreenHandler)this.f_97732_).getInventory() instanceof ForgeTableInventory)) {
            return entries;
        }
        ForgeTableInventory inventory = ((ForgeScreenHandler)this.f_97732_).getInventory();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return entries;
        }
        Optional match = world.m_7465_().m_44015_((RecipeType)RecipeTypesRegistry.FORGE_TYPE.get(), (Container)inventory, (Level)world);
        if (match.isEmpty()) {
            return entries;
        }
        ForgeRecipe recipe = (ForgeRecipe)match.get();
        ItemStack gemStack = inventory.m_8020_(1);
        if (gemStack.m_41619_()) {
            return entries;
        }
        ResourceLocation gemId = BuiltInRegistries.f_257033_.m_7981_((Object)gemStack.m_41720_());
        ForgeRecipe.GemEnchantData data = recipe.gemsToEnchantment.get(gemId.toString());
        if (data == null) {
            for (Map.Entry<String, ForgeRecipe.GemEnchantData> entry : recipe.gemsToEnchantment.entrySet()) {
                ResourceLocation tagId;
                TagKey tag;
                String key = entry.getKey();
                if (!key.startsWith("#") || !gemStack.m_204117_(tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)(tagId = new ResourceLocation(key.substring(1)))))) continue;
                data = entry.getValue();
                break;
            }
        }
        if (data == null) {
            return entries;
        }
        Enchantment ench = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(data.enchantmentId());
        int currentLevel = EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)inventory.m_8020_(0));
        int nextLevel = data.levelMap().stream().filter(l -> l > currentLevel).findFirst().orElse(-1);
        if (nextLevel == -1) {
            return entries;
        }
        int fuelCost = data.costModifierPerLevel().getOrDefault(nextLevel, 0);
        entries.add("Fuel Cost: \u00a76" + fuelCost);
        List reqs = data.requirementsPerLevel().getOrDefault(nextLevel, List.of());
        for (Requirement r : reqs) {
            if (r instanceof ExpPointsRequirement) {
                ExpPointsRequirement epr = (ExpPointsRequirement)r;
                entries.add("Need \u00a7b" + epr.minPoints + "\u00a7r XP points");
            }
            if (r instanceof ExpLevelsRequirement) {
                ExpLevelsRequirement elr = (ExpLevelsRequirement)r;
                entries.add("Need level \u00a7a" + elr.minLevel);
            }
            if (!(r instanceof HasEnchantmentRequirement)) continue;
            HasEnchantmentRequirement her = (HasEnchantmentRequirement)r;
            Enchantment reqEnch = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(her.enchantId);
            if (reqEnch != null) {
                ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
                EnchantmentHelper.m_44865_(Map.of(reqEnch, her.minLevel), (ItemStack)book);
                entries.add(book);
                continue;
            }
            entries.add("Requires " + her.enchantId.m_135815_() + " lvl " + her.minLevel);
        }
        return entries;
    }

    public void startAnimation() {
        ConfigHelper.debug("Starting Animation");
        this.animating = true;
        this.arrowR = 0.0f;
        this.arrowL = 0.0f;
        this.arrowM = 0.0f;
        this.phase = 0;
        this.animationCounter = 0;
        this.setArrowTickSpeed();
    }

    public void showFailOverlay(Component msg, int ticks) {
        this.lastFailMsg = msg;
        this.lastFailTimer = Math.max(1, ticks);
    }

    private static class CraftButtonWidget
    extends ImageButton {
        private boolean pressed = false;
        private final int deselectTicks = 5;
        private long unpressAtTick = -1L;

        public CraftButtonWidget(int x, int y, ResourceLocation texture, Button.OnPress pressAction) {
            super(x, y, 16, 16, 0, 176, 16, texture, pressAction);
        }

        private static long clientTick() {
            Minecraft mc = Minecraft.m_91087_();
            return mc != null && mc.f_91074_ != null ? (long)mc.f_91074_.f_19797_ : 0L;
        }

        public void setPressed(boolean pressed) {
            this.pressed = pressed;
        }

        public void m_5691_() {
            super.m_5691_();
            this.pressed = true;
            this.unpressAtTick = CraftButtonWidget.clientTick() + 5L;
            ConfigHelper.debug("Craft Button Pressed (hold 5 ticks)");
        }

        public void m_87963_(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
            if (this.pressed && CraftButtonWidget.clientTick() >= this.unpressAtTick) {
                this.pressed = false;
            }
            int vOffset = this.pressed ? this.f_94226_ : 0;
            ctx.m_280218_(this.f_94223_, this.m_252754_(), this.m_252907_(), this.f_94224_, this.f_94225_ + vOffset, this.f_93618_, this.f_93619_);
        }
    }
}

