/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.screens.handlers;

import com.github.spacemex.enchantmentforge.blocks.entitys.ForgeTableBlockEntity;
import com.github.spacemex.enchantmentforge.config.ConfigHelper;
import com.github.spacemex.enchantmentforge.forgeregistry.ScreenHandlersRegistry;
import com.github.spacemex.enchantmentforge.inventories.ForgeTableInventory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ForgeScreenHandler
extends AbstractContainerMenu {
    private final ForgeTableInventory inventory;
    private final ContainerData properties;
    private final ForgeTableBlockEntity blockEntity;

    public ForgeScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, new ForgeTableInventory(), (ContainerData)new SimpleContainerData(2), null);
    }

    public ForgeScreenHandler(int syncId, Inventory playerInventory, ForgeTableInventory inventory, ContainerData properties, ForgeTableBlockEntity blockEntity) {
        super((MenuType)ScreenHandlersRegistry.FORGE_SCREEN_HANDLER.get(), syncId);
        this.inventory = inventory;
        this.properties = properties;
        this.blockEntity = blockEntity;
        ForgeScreenHandler.m_38869_((Container)inventory, (int)3);
        this.m_38897_(new Slot((Container)inventory, 0, 62, 35));
        this.m_38897_(new Slot((Container)inventory, 1, 95, 35));
        this.m_38897_(new Slot((Container)inventory, 2, 80, 53));
        this.m_38884_(properties);
        this.createPlayerInventorySlots(playerInventory);
    }

    private void createPlayerInventorySlots(Inventory playerInventory) {
        int y = 84;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, y + row * 18));
            }
        }
        this.createPlayerHotbarSlots(playerInventory, y);
        this.m_38897_(new Slot((Container)playerInventory, 36, 8, 64){

            public boolean m_5857_(ItemStack stack) {
                ArmorItem armorItem;
                Item item = stack.m_41720_();
                return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == EquipmentSlot.FEET;
            }
        });
        this.m_38897_(new Slot((Container)playerInventory, 37, 8, 46){

            public boolean m_5857_(ItemStack stack) {
                ArmorItem armorItem;
                Item item = stack.m_41720_();
                return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == EquipmentSlot.LEGS;
            }
        });
        this.m_38897_(new Slot((Container)playerInventory, 38, 8, 28){

            public boolean m_5857_(ItemStack stack) {
                ArmorItem armorItem;
                Item item = stack.m_41720_();
                return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == EquipmentSlot.CHEST;
            }
        });
        this.m_38897_(new Slot((Container)playerInventory, 39, 8, 10){

            public boolean m_5857_(ItemStack stack) {
                ArmorItem armorItem;
                Item item = stack.m_41720_();
                return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == EquipmentSlot.HEAD;
            }
        });
    }

    private void createPlayerHotbarSlots(Inventory playerInventory, int y) {
        int hotbarY = y + 58;
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, hotbarY));
        }
    }

    public int getServerProgress() {
        return this.properties.m_6413_(0);
    }

    public int getServerMaxProgress() {
        return this.properties.m_6413_(1);
    }

    public ForgeTableBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean fromLast) {
        return super.m_38903_(stack, startIndex, endIndex, fromLast);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            newStack = originalStack.m_41777_();
            if (slotIndex < this.inventory.m_6643_() ? !this.m_38903_(originalStack, this.inventory.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(originalStack, 0, this.inventory.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }

    public boolean m_6875_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public ForgeTableInventory getInventory() {
        return this.inventory;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void craftSound(boolean success) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && success) {
            ConfigHelper.debug("Client Playing Craft Sound");
            player.m_5496_(SoundEvents.f_11671_, 1.0f, player.m_217043_().m_188501_() * 0.1f + 0.9f);
        } else {
            ConfigHelper.debug("Cannot Play Craft Sound");
        }
    }
}

