/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.yml;

import com.github.spacemex.yml.TParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class YamlConfigUtil {
    private final Map<String, Object> root;

    public YamlConfigUtil(Map<String, Object> root) {
        this.root = root;
    }

    public String getString(String key, String defaultValue) {
        Object val = this.resolvePath(key);
        return val instanceof String ? (String)val : defaultValue;
    }

    public int getInt(String key, int defaultValue) {
        Object val = this.resolvePath(key);
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val instanceof String) {
            try {
                return Integer.parseInt((String)val);
            }
            catch (NumberFormatException e) {
                System.err.println("Failed to parse int value for key " + key);
                System.err.println("Returning default value: " + defaultValue);
            }
        }
        return defaultValue;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object val = this.resolvePath(key);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return Boolean.parseBoolean((String)val);
        }
        return defaultValue;
    }

    public List<String> getStringList(String key, List<String> defaultValue) {
        Object val = this.resolvePath(key);
        if (val instanceof List) {
            List list = (List)val;
            return list.stream().filter(item -> item instanceof String).map(String.class::cast).toList();
        }
        return defaultValue;
    }

    public float getFloat(String key, float defaultValue) {
        Object val = this.resolvePath(key);
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        if (val instanceof String) {
            try {
                return Float.parseFloat((String)val);
            }
            catch (NumberFormatException e) {
                System.err.println("Failed to parse float value for key " + key);
                System.err.println("Returning default value: " + defaultValue);
            }
        }
        return defaultValue;
    }

    public long getLong(String key, long defaultValue) {
        Object val = this.resolvePath(key);
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        if (val instanceof String) {
            try {
                return Long.parseLong((String)val);
            }
            catch (NumberFormatException e) {
                System.err.println("Failed to parse long value for key " + key);
                System.err.println("Returning default value: " + defaultValue);
            }
        }
        return defaultValue;
    }

    public List<Double> getDoubleList(String key, List<Double> defaultValue) {
        Object val = this.resolvePath(key);
        if (val instanceof List) {
            List list = (List)val;
            return list.stream().map(item -> {
                if (item instanceof Number) {
                    return ((Number)item).doubleValue();
                }
                if (item instanceof String) {
                    String s = (String)item;
                    try {
                        return Double.parseDouble(s);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return null;
            }).filter(Objects::nonNull).toList();
        }
        return defaultValue;
    }

    public double getDouble(String key, double defaultValue) {
        Object val = this.resolvePath(key);
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof String) {
            try {
                return Double.parseDouble((String)val);
            }
            catch (NumberFormatException e) {
                System.err.println("Failed to parse double value for key " + key);
                System.err.println("Returning default value: " + defaultValue);
            }
        }
        return defaultValue;
    }

    public List<Integer> getIntList(String key, List<Integer> defaultValue) {
        Object val = this.resolvePath(key);
        if (val instanceof List) {
            List list = (List)val;
            return list.stream().map(item -> {
                if (item instanceof Number) {
                    return ((Number)item).intValue();
                }
                if (item instanceof String) {
                    String s = (String)item;
                    try {
                        return Integer.parseInt(s);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return null;
            }).filter(Objects::nonNull).toList();
        }
        return defaultValue;
    }

    public List<Long> getLongList(String key, List<Long> defaultValue) {
        Object val = this.resolvePath(key);
        if (val instanceof List) {
            List list = (List)val;
            return list.stream().map(item -> {
                if (item instanceof Number) {
                    return ((Number)item).longValue();
                }
                if (item instanceof String) {
                    String s = (String)item;
                    try {
                        return Long.parseLong(s);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return null;
            }).filter(Objects::nonNull).toList();
        }
        return defaultValue;
    }

    public Map<String, String> getStringMap(String key, Map<String, String> defaultValue) {
        Object val = this.resolvePath(key);
        if (val instanceof Map) {
            Map map = (Map)val;
            return map.entrySet().stream().filter(e -> e.getKey() instanceof String && e.getValue() instanceof String).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
        }
        return defaultValue;
    }

    public Map<String, Integer> getIntMap(String key, Map<String, Integer> defaultValue) {
        Object val = this.resolvePath(key);
        if (val instanceof Map) {
            Map map = (Map)val;
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            for (Map.Entry entry : map.entrySet()) {
                Object k = entry.getKey();
                if (!(k instanceof String)) continue;
                String k2 = (String)k;
                Object v = entry.getValue();
                try {
                    if (v instanceof Number) {
                        result.put(k2, ((Number)v).intValue());
                        continue;
                    }
                    if (!(v instanceof String)) continue;
                    String s = (String)v;
                    result.put(k2, Integer.parseInt(s));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return result;
        }
        return defaultValue;
    }

    public Map<String, Double> getDoubleMap(String key, Map<String, Double> defaultValue) {
        Object val = this.resolvePath(key);
        if (val instanceof Map) {
            Map map = (Map)val;
            HashMap<String, Double> result = new HashMap<String, Double>();
            for (Map.Entry entry : map.entrySet()) {
                Object k = entry.getKey();
                if (!(k instanceof String)) continue;
                String k2 = (String)k;
                Object v = entry.getValue();
                try {
                    if (v instanceof Number) {
                        result.put(k2, ((Number)v).doubleValue());
                        continue;
                    }
                    if (!(v instanceof String)) continue;
                    String s = (String)v;
                    result.put(k2, Double.parseDouble(s));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return result;
        }
        return defaultValue;
    }

    public <T> Map<String, T> getMap(String path, TParser<T> parser, Map<String, T> defaultValue) {
        Object val = this.resolvePath(path);
        if (val instanceof Map) {
            Map map = (Map)val;
            HashMap<String, T> result = new HashMap<String, T>();
            for (Map.Entry entry : map.entrySet()) {
                Object k = entry.getKey();
                if (!(k instanceof String)) continue;
                String k2 = (String)k;
                try {
                    T parsed = parser.parse(entry.getValue());
                    if (parsed == null) continue;
                    result.put(k2, parsed);
                }
                catch (Exception exception) {}
            }
            return result;
        }
        return defaultValue;
    }

    private Object resolvePath(String path) {
        String[] keys = path.split("\\.");
        Object current = this.root;
        for (String key : keys) {
            if (!(current instanceof Map)) {
                return null;
            }
            Map<String, Object> map = current;
            current = map.get(key);
        }
        return current;
    }

    public YamlConfigUtil getSection(String key) {
        Object val = this.resolvePath(key);
        if (val instanceof Map) {
            Map map = (Map)val;
            return new YamlConfigUtil(map);
        }
        return null;
    }
}

