/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge;

import com.github.spacemex.enchantmentforge.blocks.entitys.ForgeTableBlockEntity;
import com.github.spacemex.enchantmentforge.commands.TakeExpLevelCommand;
import com.github.spacemex.enchantmentforge.config.CommonConfig;
import com.github.spacemex.enchantmentforge.config.ConfigHelper;
import com.github.spacemex.enchantmentforge.config.ConfigReader;
import com.github.spacemex.enchantmentforge.forgeregistry.BlockRegistry;
import com.github.spacemex.enchantmentforge.forgeregistry.Register;
import com.github.spacemex.enchantmentforge.forgeregistry.ScreenHandlersRegistry;
import com.github.spacemex.enchantmentforge.networking.eventhandler.ConfigSyncHandler;
import com.github.spacemex.enchantmentforge.networking.packets.c2s.OnCraftButtonPressedPacket;
import com.github.spacemex.enchantmentforge.networking.packets.s2c.SendFailMessageToClientsOverlay;
import com.github.spacemex.enchantmentforge.networking.packets.s2c.StartForgeAnimationPacket;
import com.github.spacemex.enchantmentforge.networking.packets.s2c.SyncConfigPacket;
import com.github.spacemex.enchantmentforge.screens.ForgeScreen;
import com.github.spacemex.enchantmentforge.screens.handlers.ForgeScreenHandler;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_437;

public final class Enchantmentforge {
    public static final String MOD_ID = "enchantmentforge";

    public static void init() {
        Register.register();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)OnCraftButtonPressedPacket.ID, (buf, ctx) -> {
            class_1657 patt0$temp = ctx.getPlayer();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                class_1703 patt1$temp = player.field_7512;
                if (patt1$temp instanceof ForgeScreenHandler) {
                    ForgeScreenHandler handler = (ForgeScreenHandler)patt1$temp;
                    ConfigHelper.debug("Server Received OnCraftButtonPressedPacket");
                    ForgeTableBlockEntity entity = handler.getBlockEntity();
                    if (entity != null) {
                        entity.startCraft();
                    }
                }
            }
        });
        CommonConfig.generateConfig(Platform.getConfigFolder().resolve("enchantmentforge/config.yml"));
        ConfigSyncHandler.handle();
        TakeExpLevelCommand.init();
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        MenuRegistry.registerScreenFactory((class_3917)((class_3917)ScreenHandlersRegistry.FORGE_SCREEN_HANDLER.get()), ForgeScreen::new);
        RenderTypeRegistry.register((class_1921)class_1921.method_23579(), (class_2248[])new class_2248[]{(class_2248)BlockRegistry.FORGE_TABLE_BLOCK.get()});
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)StartForgeAnimationPacket.ID, (buf, ctx) -> ctx.queue(() -> {
            class_310 client = class_310.method_1551();
            class_437 patt0$temp = client.field_1755;
            if (patt0$temp instanceof ForgeScreen) {
                ForgeScreen screen = (ForgeScreen)patt0$temp;
                ConfigHelper.debug("Client Received StartForgeAnimationPacket");
                screen.startAnimation();
            }
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)SendFailMessageToClientsOverlay.ID, (buf, ctx) -> {
            boolean success = buf.readBoolean();
            String message = buf.method_10800(Short.MAX_VALUE);
            ctx.queue(() -> {
                class_437 patt0$temp;
                class_310 client = class_310.method_1551();
                if (!success && (patt0$temp = class_310.method_1551().field_1755) instanceof ForgeScreen) {
                    ForgeScreen screen = (ForgeScreen)patt0$temp;
                    screen.showFailOverlay((class_2561)class_2561.method_43470((String)message), 600);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)SyncConfigPacket.ID, (buf, ctx) -> {
            SyncConfigPacket packet = SyncConfigPacket.decode(buf);
            ConfigReader.setSyncedConfig(packet.getConfig());
        });
    }
}

