/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.blocks.entitys;

import com.github.spacemex.enchantmentforge.config.ConfigHelper;
import com.github.spacemex.enchantmentforge.forgeregistry.EntityTypesRegistry;
import com.github.spacemex.enchantmentforge.forgeregistry.RecipeTypesRegistry;
import com.github.spacemex.enchantmentforge.inventories.ForgeTableInventory;
import com.github.spacemex.enchantmentforge.networking.packets.s2c.StartForgeAnimationPacket;
import com.github.spacemex.enchantmentforge.recipes.ForgeRecipe;
import com.github.spacemex.enchantmentforge.screens.handlers.ForgeScreenHandler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ForgeTableBlockEntity
extends class_2586
implements class_3908 {
    public ForgeTableInventory inventory = new ForgeTableInventory();
    private int progress = 0;
    private int maxProgress = 0;
    private boolean startCraft = false;
    @Nullable
    private UUID lastPlayerId = null;
    @Nullable
    private String lastToolSignature = null;
    private final class_3913 properties = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> ForgeTableBlockEntity.this.progress;
                case 1 -> ForgeTableBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
        }

        public int method_17389() {
            return 2;
        }
    };

    public ForgeTableBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypesRegistry.FORGE_TABLE_ENTITY_TYPE.get(), pos, state);
        this.inventory.setMarkDirtyCallback(this::onInventoryChanged);
        try {
            this.maxProgress = Math.max(1, this.getConfiguredTotalTickTime());
        }
        catch (Throwable t) {
            this.maxProgress = 200;
        }
    }

    private int getConfiguredTotalTickTime() {
        if (ConfigHelper.isAwaitDrain()) {
            return ConfigHelper.getTotalTickTime() * 2;
        }
        return ConfigHelper.getTotalTickTime();
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.enchantmentforge.forge_table");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (!this.startCraft) {
                this.lastPlayerId = serverPlayer.method_5667();
            }
        }
        return new ForgeScreenHandler(syncId, playerInventory, this.inventory, this.properties, this);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, ForgeTableBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        if (!blockEntity.startCraft) {
            return;
        }
        if (!blockEntity.hasValidInputs(blockEntity.inventory)) {
            blockEntity.resetProgressIfNeeded();
            ConfigHelper.debug("Invalid Inputs");
            return;
        }
        Optional recipeOpt = world.method_8433().method_8132((class_3956)RecipeTypesRegistry.FORGE_TYPE.get(), (class_1263)blockEntity.inventory, world);
        if (recipeOpt.isEmpty()) {
            blockEntity.resetProgressIfNeeded();
            ConfigHelper.debug("No Recipe Found");
            return;
        }
        class_3222 player = blockEntity.resolveLastPlayer(world);
        if (player == null) {
            blockEntity.resetProgressIfNeeded();
            ConfigHelper.debug("No Player Found");
            return;
        }
        boolean starting = blockEntity.progress == 0;
        ++blockEntity.progress;
        if (starting) {
            ConfigHelper.debug("[Entity]Syncing Animation");
            if (player.field_7512 instanceof ForgeScreenHandler) {
                class_2540 buf = new class_2540(Unpooled.buffer());
                new StartForgeAnimationPacket().write(buf);
                NetworkManager.sendToPlayer((class_3222)player, (class_2960)StartForgeAnimationPacket.ID, (class_2540)buf);
            }
        }
        if (blockEntity.progress >= blockEntity.maxProgress) {
            ForgeRecipe recipe = (ForgeRecipe)recipeOpt.get();
            class_1799 existingToolStack = blockEntity.inventory.method_5438(0);
            class_1799 result = recipe.craftWithRequirements(blockEntity.inventory, world.method_30349(), player);
            blockEntity.progress = 0;
            if (!result.method_7960() && recipe.isSuccess() && player.field_7512 instanceof ForgeScreenHandler) {
                ((ForgeScreenHandler)player.field_7512).craftSound(true);
            }
            if (!class_1799.method_7973((class_1799)existingToolStack, (class_1799)result)) {
                blockEntity.lastToolSignature = blockEntity.computeToolSignature();
            }
            blockEntity.method_5431();
            blockEntity.startCraft = false;
        }
    }

    public void startCraft() {
        if (this.startCraft) {
            ConfigHelper.debug("Already Starting Craft");
        } else {
            ConfigHelper.debug("Setting Start Craft");
            this.startCraft = true;
        }
    }

    private boolean hasValidInputs(class_1263 inv) {
        return !inv.method_5438(0).method_7960() && !inv.method_5438(1).method_7960() && !inv.method_5438(2).method_7960();
    }

    private void resetProgressIfNeeded() {
        if (this.progress != 0) {
            this.progress = 0;
        }
        if (this.startCraft) {
            this.startCraft = false;
        }
        this.method_5431();
    }

    @Nullable
    private class_3222 resolveLastPlayer(class_1937 world) {
        if (!(world instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)world;
        if (this.lastPlayerId == null) {
            return null;
        }
        return serverWorld.method_8503().method_3760().method_14602(this.lastPlayerId);
    }

    private String computeToolSignature() {
        class_1799 tool = this.inventory.method_5438(0);
        if (tool.method_7960()) {
            return "empty";
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)tool.method_7909());
        String nbt = tool.method_7969() == null ? "" : tool.method_7969().toString();
        return String.valueOf(id) + "|" + tool.method_7947() + "|" + nbt;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void onInventoryChanged() {
        ConfigHelper.debug("Checking Inventory");
        String currentSig = this.computeToolSignature();
        if (!Objects.equals(currentSig, this.lastToolSignature)) {
            this.lastToolSignature = currentSig;
            this.progress = 0;
            ConfigHelper.debug("Tool Changed");
        }
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public class_3913 getProperties() {
        return this.properties;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.inventory.writeNbt(nbt);
        nbt.method_10569("Progress", this.progress);
        nbt.method_10569("MaxProgress", this.maxProgress);
        nbt.method_10556("StartCraft", this.startCraft);
        if (this.lastToolSignature != null) {
            nbt.method_10582("LastToolSig", this.lastToolSignature);
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory.readNbt(nbt);
        this.progress = nbt.method_10550("Progress");
        this.maxProgress = Math.max(1, nbt.method_10545("MaxProgress") ? nbt.method_10550("MaxProgress") : this.maxProgress);
        this.startCraft = nbt.method_10577("StartCraft");
        this.lastToolSignature = nbt.method_10545("LastToolSig") ? nbt.method_10558("LastToolSig") : null;
    }
}

