/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.config;

import com.github.spacemex.enchantmentforge.libs.snakeyaml.Yaml;
import com.github.spacemex.yml.YamlConfigUtil;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import net.fabricmc.api.EnvType;

public class ConfigReader {
    private static YamlConfigUtil syncedConfig;
    private static Map<String, Object> syncedRaw;
    private final YamlConfigUtil localConfig;
    private final Map<String, Object> localRaw;

    public ConfigReader() {
        Map data;
        File yamlFile = Platform.getConfigFolder().resolve("enchantmentforge/config.yml").toFile();
        try (FileReader reader = new FileReader(yamlFile);){
            data = (Map)new Yaml().load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config file", e);
        }
        this.localConfig = new YamlConfigUtil(data);
        this.localRaw = data;
    }

    public static void setSyncedConfig(Map<String, Object> data) {
        syncedConfig = new YamlConfigUtil(data);
        syncedRaw = data;
    }

    public YamlConfigUtil getConfig() {
        if (Platform.getEnv() == EnvType.CLIENT && syncedConfig != null) {
            return syncedConfig;
        }
        return this.localConfig;
    }

    public Map<String, Object> getRawLocal() {
        return this.localRaw;
    }
}

