/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.recipes;

import com.github.spacemex.enchantmentforge.config.ConfigHelper;
import com.github.spacemex.enchantmentforge.forgeregistry.RecipeSerializersRegistry;
import com.github.spacemex.enchantmentforge.forgeregistry.RecipeTypesRegistry;
import com.github.spacemex.enchantmentforge.inventories.ForgeTableInventory;
import com.github.spacemex.enchantmentforge.networking.packets.s2c.SendFailMessageToClientsOverlay;
import com.github.spacemex.enchantmentforge.recipes.requirements.ExpLevelsRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.ExpPointsRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.HasEnchantmentRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.data.Requirement;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ForgeRecipe
implements class_1860<ForgeTableInventory> {
    private boolean success;
    private final class_2960 id;
    private final class_1856 tool;
    private final class_1856 fuel;
    public final Map<String, GemEnchantData> gemsToEnchantment;

    public ForgeRecipe(class_2960 id, class_1856 tool, class_1856 fuel, Map<String, GemEnchantData> gemsToEnchantment) {
        this.id = id;
        this.tool = tool;
        this.fuel = fuel;
        this.gemsToEnchantment = gemsToEnchantment;
        this.success = false;
    }

    public boolean matches(ForgeTableInventory inventory, class_1937 world) {
        if (inventory.method_5439() < 3) {
            return false;
        }
        class_1799 toolStack = inventory.method_5438(0);
        class_1799 gemStack = inventory.method_5438(1);
        class_1799 fuelStack = inventory.method_5438(2);
        if (!this.tool.method_8093(toolStack)) {
            return false;
        }
        if (!this.fuel.method_8093(fuelStack)) {
            return false;
        }
        GemEnchantData data = this.resolveGemData(gemStack);
        if (data == null) {
            return false;
        }
        class_1887 enchant = (class_1887)class_7923.field_41176.method_10223(data.enchantmentId());
        if (enchant == null) {
            return false;
        }
        int currentLevel = class_1890.method_8225((class_1887)enchant, (class_1799)toolStack);
        int nextLevel = ForgeRecipe.nextLevelAbove(currentLevel, data.levelMap());
        return currentLevel < enchant.method_8183() && nextLevel > 0;
    }

    private static void sendCraftFail(class_3222 player, String message) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeBoolean(false);
        buf.method_10814(message);
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)SendFailMessageToClientsOverlay.ID, (class_2540)buf);
    }

    private static String failMessageFor(Requirement req, class_3222 player, class_1799 tool) {
        if (req instanceof ExpLevelsRequirement) {
            ExpLevelsRequirement elr = (ExpLevelsRequirement)req;
            return "Need level " + elr.minLevel;
        }
        if (req instanceof ExpPointsRequirement) {
            ExpPointsRequirement epr = (ExpPointsRequirement)req;
            return "Need " + epr.minPoints + " XP points";
        }
        if (req instanceof HasEnchantmentRequirement) {
            HasEnchantmentRequirement her = (HasEnchantmentRequirement)req;
            class_1887 ench = (class_1887)class_7923.field_41176.method_10223(her.enchantId);
            if (ench != null) {
                String name = ench.method_8179(her.minLevel).getString();
                return "Requires " + name;
            }
            return "Requires " + her.enchantId.method_12832() + " lvl " + her.minLevel;
        }
        return "A requirement was not met.";
    }

    private GemEnchantData resolveGemData(class_1799 gemStack) {
        class_2960 gemId = class_7923.field_41178.method_10221((Object)gemStack.method_7909());
        GemEnchantData direct = this.gemsToEnchantment.get(gemId.toString());
        if (direct != null) {
            return direct;
        }
        for (Map.Entry<String, GemEnchantData> e : this.gemsToEnchantment.entrySet()) {
            class_6862 tag;
            class_2960 tagId;
            String key = e.getKey();
            if (!key.startsWith("#") || (tagId = class_2960.method_12829((String)key.substring(1))) == null || !gemStack.method_31573(tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId))) continue;
            return e.getValue();
        }
        return null;
    }

    private static int nextLevelAbove(int current, List<Integer> levels) {
        for (int lvl : levels) {
            if (lvl <= current) continue;
            return lvl;
        }
        return -1;
    }

    public class_1799 craftWithRequirements(class_1263 inventory, class_5455 registryManager, class_3222 player) {
        class_2960 tagId;
        this.success = false;
        class_1799 toolStack = inventory.method_5438(0);
        class_1799 gemStack = inventory.method_5438(1);
        class_1799 fuelStack = inventory.method_5438(2);
        if (toolStack.method_7960() || gemStack.method_7960() || fuelStack.method_7960()) {
            return class_1799.field_8037;
        }
        class_2960 gemId = class_7923.field_41178.method_10221((Object)gemStack.method_7909());
        String gemKey = gemId.toString();
        GemEnchantData data = this.gemsToEnchantment.get(gemKey);
        if (data == null) {
            for (Map.Entry<String, GemEnchantData> entry : this.gemsToEnchantment.entrySet()) {
                class_6862 tag;
                String key = entry.getKey();
                if (!key.startsWith("#") || !gemStack.method_31573(tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)(tagId = new class_2960(key.substring(1)))))) continue;
                data = entry.getValue();
                break;
            }
        }
        if (data == null) {
            return toolStack;
        }
        class_1887 enchant = (class_1887)class_7923.field_41176.method_10223(data.enchantmentId);
        if (enchant == null) {
            return toolStack;
        }
        int currentLevel = class_1890.method_8225((class_1887)enchant, (class_1799)toolStack);
        if (currentLevel == enchant.method_8183()) {
            return toolStack;
        }
        if (currentLevel <= 0) {
            try {
                currentLevel = class_1890.method_37424((class_2487)Objects.requireNonNull(toolStack.method_7969()));
            }
            catch (Exception key) {
                // empty catch block
            }
        }
        int nextLevel = -1;
        tagId = data.levelMap.iterator();
        while (tagId.hasNext()) {
            int lvl = (Integer)tagId.next();
            if (lvl <= currentLevel) continue;
            nextLevel = lvl;
            break;
        }
        if (nextLevel <= 0) {
            return toolStack;
        }
        int requiredFuel = data.costModifierPerLevel().getOrDefault(nextLevel, Integer.MAX_VALUE);
        if (fuelStack.method_7947() < requiredFuel) {
            ForgeRecipe.sendCraftFail(player, "Insufficient Fuel");
            return toolStack;
        }
        List requirements = data.requirementsPerLevel().getOrDefault(nextLevel, Collections.emptyList());
        boolean requirementsMet = true;
        if (!requirements.isEmpty()) {
            for (Requirement requirement : requirements) {
                if (requirement.check(player, toolStack)) {
                    ConfigHelper.debug("Successfully Met Requirement");
                    requirement.onSuccess(player);
                    continue;
                }
                ForgeRecipe.sendCraftFail(player, ForgeRecipe.failMessageFor(requirement, player, toolStack));
                requirement.onFail(player);
                requirementsMet = false;
                break;
            }
        }
        if (!requirementsMet) {
            this.success = false;
            return toolStack;
        }
        class_1799 result = toolStack.method_7972();
        Map existingEnchants = class_1890.method_8222((class_1799)result);
        existingEnchants.put(enchant, nextLevel);
        class_1890.method_8214((Map)existingEnchants, (class_1799)result);
        fuelStack.method_7934(requiredFuel);
        gemStack.method_7934(1);
        inventory.method_5447(0, result);
        inventory.method_5447(1, gemStack);
        inventory.method_5447(2, fuelStack);
        this.success = true;
        return result;
    }

    public class_1799 craft(ForgeTableInventory inventory, class_5455 registryManager) {
        return class_1799.field_8037;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return class_1799.field_8037;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1856 getTool() {
        return this.tool;
    }

    public class_1856 getFuel() {
        return this.fuel;
    }

    public Map<String, GemEnchantData> getGemEnchantments() {
        return this.gemsToEnchantment;
    }

    public class_1865<?> method_8119() {
        return (class_1865)RecipeSerializersRegistry.FORGE_SERIALIZER.get();
    }

    public class_3956<?> method_17716() {
        return (class_3956)RecipeTypesRegistry.FORGE_TYPE.get();
    }

    public record GemEnchantData(class_2960 enchantmentId, List<Integer> levelMap, Map<Integer, Integer> costModifierPerLevel, Map<Integer, List<Requirement>> requirementsPerLevel) {
    }

    public static class Serializer
    implements class_1865<ForgeRecipe> {
        public ForgeRecipe read(class_2960 id, JsonObject json) {
            class_1856 tool = class_1856.method_52177((JsonElement)json.get("tool"));
            class_1856 fuel = class_1856.method_52177((JsonElement)json.get("fuel"));
            JsonObject gemObject = json.getAsJsonObject("gems_to_enchantment");
            HashMap<String, GemEnchantData> map = new HashMap<String, GemEnchantData>();
            for (Map.Entry entry : gemObject.entrySet()) {
                String gemId = (String)entry.getKey();
                JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
                class_2960 enchantId = new class_2960(data.get("enchantment").getAsString());
                ArrayList<Integer> levelMap = new ArrayList<Integer>();
                for (JsonElement e : data.getAsJsonArray("level_map")) {
                    levelMap.add(e.getAsInt());
                }
                HashMap<Integer, Integer> costs = new HashMap<Integer, Integer>();
                JsonObject costsJson = data.getAsJsonObject("cost_modifier_per_level");
                for (Map.Entry c : costsJson.entrySet()) {
                    costs.put(Integer.parseInt((String)c.getKey()), ((JsonElement)c.getValue()).getAsInt());
                }
                HashMap<Integer, List<Requirement>> requirementsPerLevel = new HashMap<Integer, List<Requirement>>();
                if (data.has("requirements")) {
                    for (JsonElement reqElement : data.getAsJsonArray("requirements")) {
                        JsonObject reqObj = reqElement.getAsJsonObject();
                        for (Map.Entry reqEntry : reqObj.entrySet()) {
                            int level = Integer.parseInt((String)reqEntry.getKey());
                            JsonObject reqData = ((JsonElement)reqEntry.getValue()).getAsJsonObject();
                            Requirement req = Requirement.fromJson(reqData);
                            requirementsPerLevel.computeIfAbsent(level, k -> new ArrayList()).add(req);
                        }
                    }
                }
                map.put(gemId, new GemEnchantData(enchantId, levelMap, costs, requirementsPerLevel));
            }
            return new ForgeRecipe(id, tool, fuel, map);
        }

        public ForgeRecipe read(class_2960 id, class_2540 buf) {
            class_1856 tool = class_1856.method_8086((class_2540)buf);
            class_1856 fuel = class_1856.method_8086((class_2540)buf);
            int gemCount = buf.method_10816();
            HashMap<String, GemEnchantData> map = new HashMap<String, GemEnchantData>();
            for (int i = 0; i < gemCount; ++i) {
                String gemId = buf.method_19772();
                class_2960 enchantId = buf.method_10810();
                int levelCount = buf.method_10816();
                ArrayList<Integer> levelMap = new ArrayList<Integer>(levelCount);
                for (int j = 0; j < levelCount; ++j) {
                    levelMap.add(buf.method_10816());
                }
                int costCount = buf.method_10816();
                HashMap<Integer, Integer> costs = new HashMap<Integer, Integer>(costCount);
                for (int j = 0; j < costCount; ++j) {
                    int level = buf.method_10816();
                    int cost = buf.method_10816();
                    costs.put(level, cost);
                }
                int reqLevels = buf.method_10816();
                HashMap<Integer, List<Requirement>> requirementsPerLevel = new HashMap<Integer, List<Requirement>>(reqLevels);
                for (int r = 0; r < reqLevels; ++r) {
                    int lvlKey = buf.method_10816();
                    int reqCount = buf.method_10816();
                    ArrayList<Requirement> reqList = new ArrayList<Requirement>(reqCount);
                    for (int q = 0; q < reqCount; ++q) {
                        reqList.add(Requirement.read(buf));
                    }
                    requirementsPerLevel.put(lvlKey, reqList);
                }
                map.put(gemId, new GemEnchantData(enchantId, levelMap, costs, requirementsPerLevel));
            }
            return new ForgeRecipe(id, tool, fuel, map);
        }

        public void write(class_2540 buf, ForgeRecipe recipe) {
            recipe.tool.method_8088(buf);
            recipe.fuel.method_8088(buf);
            buf.method_10804(recipe.gemsToEnchantment.size());
            for (Map.Entry<String, GemEnchantData> entry : recipe.gemsToEnchantment.entrySet()) {
                buf.method_10814(entry.getKey());
                GemEnchantData data = entry.getValue();
                buf.method_10812(data.enchantmentId());
                buf.method_10804(data.levelMap().size());
                Iterator<Object> iterator = data.levelMap().iterator();
                while (iterator.hasNext()) {
                    int n = iterator.next();
                    buf.method_10804(n);
                }
                buf.method_10804(data.costModifierPerLevel().size());
                for (Map.Entry entry2 : data.costModifierPerLevel().entrySet()) {
                    buf.method_10804(((Integer)entry2.getKey()).intValue());
                    buf.method_10804(((Integer)entry2.getValue()).intValue());
                }
                Map<Integer, List<Requirement>> reqs = data.requirementsPerLevel();
                buf.method_10804(reqs.size());
                for (Map.Entry<Integer, List<Requirement>> reqEntry : reqs.entrySet()) {
                    buf.method_10804(reqEntry.getKey().intValue());
                    List<Requirement> list = reqEntry.getValue();
                    buf.method_10804(list.size());
                    for (Requirement req : list) {
                        Requirement.write(buf, req);
                    }
                }
            }
        }
    }
}

