/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.recipes.requirements;

import com.github.spacemex.enchantmentforge.recipes.requirements.data.ActionData;
import com.github.spacemex.enchantmentforge.recipes.requirements.data.Requirement;
import com.google.gson.JsonObject;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class ExpLevelsRequirement
implements Requirement {
    public final int minLevel;
    private final ActionData failAction;
    private final ActionData successAction;

    public ExpLevelsRequirement(JsonObject json) {
        this.minLevel = json.has("level") ? json.get("level").getAsInt() : 0;
        this.failAction = json.has("fail") ? new ActionData(json.getAsJsonObject("fail")) : new ActionData(new JsonObject());
        this.successAction = json.has("success") ? new ActionData(json.getAsJsonObject("success")) : new ActionData(new JsonObject());
    }

    @Override
    public boolean check(class_3222 player, class_1799 itemStack) {
        return player.field_7520 >= this.minLevel;
    }

    @Override
    public void onFail(class_3222 player) {
        this.failAction.execute(player);
    }

    @Override
    public void onSuccess(class_3222 player) {
        this.successAction.execute(player);
    }

    public static ExpLevelsRequirement read(class_2540 buf) {
        int lvl = buf.method_10816();
        ActionData fail = ActionData.read(buf);
        ActionData success = ActionData.read(buf);
        return new ExpLevelsRequirement(lvl, fail, success);
    }

    public static void write(class_2540 buf, ExpLevelsRequirement req) {
        buf.method_10804(req.minLevel);
        ActionData.write(buf, req.failAction);
        ActionData.write(buf, req.successAction);
    }

    private ExpLevelsRequirement(int minLevel, ActionData failAction, ActionData successAction) {
        JsonObject tmp = new JsonObject();
        this.minLevel = minLevel;
        this.failAction = failAction;
        this.successAction = successAction;
    }
}

