/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.recipes.requirements;

import com.github.spacemex.enchantmentforge.recipes.requirements.data.ActionData;
import com.github.spacemex.enchantmentforge.recipes.requirements.data.Requirement;
import com.google.gson.JsonObject;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class ExpPointsRequirement
implements Requirement {
    public final int minPoints;
    private final ActionData failAction;
    private final ActionData successAction;

    public ExpPointsRequirement(JsonObject json) {
        this.minPoints = json.has("level") ? json.get("level").getAsInt() : 0;
        this.failAction = json.has("fail") ? new ActionData(json.getAsJsonObject("fail")) : new ActionData(new JsonObject());
        this.successAction = json.has("success") ? new ActionData(json.getAsJsonObject("success")) : new ActionData(new JsonObject());
    }

    @Override
    public boolean check(class_3222 player, class_1799 tool) {
        int totalXp = player.field_7495;
        return totalXp >= this.minPoints;
    }

    @Override
    public void onFail(class_3222 player) {
        this.failAction.execute(player);
    }

    @Override
    public void onSuccess(class_3222 player) {
        this.successAction.execute(player);
    }

    public static ExpPointsRequirement read(class_2540 buf) {
        int level = buf.method_10816();
        ActionData fail = ActionData.read(buf);
        ActionData success = ActionData.read(buf);
        JsonObject tmp = new JsonObject();
        tmp.addProperty("level", (Number)level);
        return new ExpPointsRequirement(level, fail, success);
    }

    public static void write(class_2540 buf, ExpPointsRequirement req) {
        buf.method_10804(req.minPoints);
        ActionData.write(buf, req.failAction);
        ActionData.write(buf, req.successAction);
    }

    private ExpPointsRequirement(int minPoints, ActionData failAction, ActionData successAction) {
        this.minPoints = minPoints;
        this.failAction = failAction;
        this.successAction = successAction;
    }
}

