/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.recipes.requirements;

import com.github.spacemex.enchantmentforge.recipes.requirements.data.ActionData;
import com.github.spacemex.enchantmentforge.recipes.requirements.data.Requirement;
import com.google.gson.JsonObject;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class HasEnchantmentRequirement
implements Requirement {
    public final class_2960 enchantId;
    public final int minLevel;
    private final ActionData failAction;
    private final ActionData successAction;

    public HasEnchantmentRequirement(JsonObject json) {
        this.enchantId = new class_2960(json.get("enchantment").getAsString());
        this.minLevel = json.has("min_level") ? json.get("min_level").getAsInt() : 1;
        this.failAction = json.has("fail") ? new ActionData(json.getAsJsonObject("fail")) : new ActionData(new JsonObject());
        this.successAction = json.has("success") ? new ActionData(json.getAsJsonObject("success")) : new ActionData(new JsonObject());
    }

    @Override
    public boolean check(class_3222 player, class_1799 tool) {
        class_1887 enchant = (class_1887)class_7923.field_41176.method_10223(this.enchantId);
        if (enchant == null) {
            return false;
        }
        int lvl = class_1890.method_8225((class_1887)enchant, (class_1799)tool);
        return lvl >= this.minLevel;
    }

    @Override
    public void onFail(class_3222 player) {
        this.failAction.execute(player);
    }

    @Override
    public void onSuccess(class_3222 player) {
        this.successAction.execute(player);
    }

    public static HasEnchantmentRequirement read(class_2540 buf) {
        class_2960 id = buf.method_10810();
        int min = buf.method_10816();
        ActionData fail = ActionData.read(buf);
        ActionData success = ActionData.read(buf);
        return new HasEnchantmentRequirement(id, min, fail, success);
    }

    public static void write(class_2540 buf, HasEnchantmentRequirement req) {
        buf.method_10812(req.enchantId);
        buf.method_10804(req.minLevel);
        ActionData.write(buf, req.failAction);
        ActionData.write(buf, req.successAction);
    }

    private HasEnchantmentRequirement(class_2960 id, int minLevel, ActionData fail, ActionData success) {
        JsonObject tmp = new JsonObject();
        this.enchantId = id;
        this.minLevel = minLevel;
        this.failAction = fail;
        this.successAction = success;
    }
}

