/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.recipes.requirements.data;

import com.github.spacemex.enchantmentforge.config.ConfigHelper;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class ActionData {
    private final String message;
    private final String messageType;
    private final List<String> commands;
    private class_2960 soundId;
    private float volume;
    private float pitch;

    public ActionData(JsonObject json) {
        this.message = json.has("message") ? json.get("message").getAsString() : "";
        this.messageType = json.has("message-type") ? json.get("message-type").getAsString() : "CHAT";
        this.commands = new ArrayList<String>();
        if (json.has("commands")) {
            json.getAsJsonArray("commands").forEach(e -> this.commands.add(e.getAsString()));
        }
        if (json.has("sound")) {
            ConfigHelper.debug("Action Data Has Custom Sound");
            JsonObject s = json.getAsJsonObject("sound");
            if (s.has("volume")) {
                ConfigHelper.debug("Action Data Has Custom Volume");
            } else {
                ConfigHelper.debug("Action Data Has No Volume Defaulting To 1");
            }
            if (s.has("pitch")) {
                ConfigHelper.debug("Action Data Has Custom Pitch");
            } else {
                ConfigHelper.debug("Action Data Has No Pitch Defaulting To 1");
            }
            this.soundId = class_2960.method_12829((String)s.get("type").getAsString());
            this.volume = s.has("volume") ? s.get("volume").getAsFloat() : 1.0f;
            float f = this.pitch = s.has("pitch") ? s.get("pitch").getAsFloat() : 1.0f;
            if (this.soundId.toString().isEmpty() || Objects.equals(this.soundId.toString(), "")) {
                this.soundId = null;
                this.volume = 1.0f;
                this.pitch = 1.0f;
            }
        } else {
            ConfigHelper.debug("Action Data Has No Custom Sound");
            this.soundId = null;
            this.volume = 1.0f;
            this.pitch = 1.0f;
        }
        if (!this.message.isEmpty()) {
            ConfigHelper.debug("Action Data Has Message : " + this.message);
        } else {
            ConfigHelper.debug("Action Data Has No Message : " + this.message);
        }
        if (!this.commands.isEmpty()) {
            ConfigHelper.debug("Action Data Has Commands : " + String.valueOf(this.commands));
        } else {
            ConfigHelper.debug("Action Data Has No Commands : " + String.valueOf(this.commands));
        }
    }

    public static ActionData read(class_2540 buf) {
        String message = buf.method_10800(Short.MAX_VALUE);
        String messageType = buf.method_10800(Short.MAX_VALUE);
        int cmdCount = buf.method_10816();
        ArrayList<String> commands = new ArrayList<String>(cmdCount);
        for (int i = 0; i < cmdCount; ++i) {
            commands.add(buf.method_10800(Short.MAX_VALUE));
        }
        boolean hasSound = buf.readBoolean();
        class_2960 soundId = null;
        float volume = 1.0f;
        float pitch = 1.0f;
        if (hasSound) {
            soundId = buf.method_10810();
            volume = buf.readFloat();
            pitch = buf.readFloat();
        }
        JsonObject tmp = new JsonObject();
        tmp.addProperty("message", message);
        tmp.addProperty("message-type", messageType);
        ActionData action = new ActionData(tmp);
        action.commands.clear();
        action.commands.addAll(commands);
        return new ActionData(message, messageType, commands, soundId, volume, pitch);
    }

    private ActionData(String message, String messageType, List<String> commands, class_2960 soundId, float volume, float pitch) {
        this.message = message;
        this.messageType = messageType;
        this.commands = new ArrayList<String>(commands);
        this.soundId = soundId;
        this.volume = volume;
        this.pitch = pitch;
    }

    public void execute(class_3222 player) {
        if (this.message != null && !this.message.isEmpty()) {
            ConfigHelper.debug("Executing Custom Message : " + this.message + " with Type : " + this.messageType);
            boolean actionBar = "ACTION".equalsIgnoreCase(this.messageType);
            player.method_43502(class_2561.method_30163((String)this.message), actionBar);
        }
        if (!this.commands.isEmpty() && player.method_5682() != null) {
            ConfigHelper.debug("Executing Custom Commands");
            MinecraftServer server = player.method_5682();
            class_2168 silentSource = server.method_3739().method_36321(class_2165.field_17395).method_9217();
            for (String cmd : this.commands) {
                String parsed = cmd.replace("%player%", player.method_5820()).replace("%player_coords%", player.method_24515().method_10263() + " " + player.method_24515().method_10264() + " " + player.method_24515().method_10260());
                ConfigHelper.debug("Parsed Command " + parsed);
                try {
                    ConfigHelper.debug("Executing Command: " + parsed);
                    server.method_3734().method_44252(silentSource, parsed);
                }
                catch (Exception e) {
                    ConfigHelper.debug("Saved You From A Crash :p");
                    ConfigHelper.debug("Failed to execute Command: " + parsed);
                }
            }
        }
        if (this.soundId != null || this.soundId.toString().isEmpty()) {
            ConfigHelper.debug("Executing Custom Sound With ID: " + String.valueOf(this.soundId));
            class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(this.soundId);
            if (soundEvent != null) {
                player.method_37908().method_8396(null, player.method_24515(), soundEvent, class_3419.field_15248, this.volume, this.pitch);
            }
        }
    }

    public static void write(class_2540 buf, ActionData action) {
        buf.method_10814(action.message == null ? "" : action.message);
        buf.method_10814(action.messageType == null ? "" : action.messageType);
        buf.method_10804(action.commands.size());
        for (String c : action.commands) {
            buf.method_10814(c);
        }
        buf.writeBoolean(action.soundId != null);
        if (action.soundId != null) {
            buf.method_10812(action.soundId);
            buf.writeFloat(action.volume);
            buf.writeFloat(action.pitch);
        }
    }
}

