/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.recipes.requirements.data;

import com.github.spacemex.enchantmentforge.config.ConfigHelper;
import com.github.spacemex.enchantmentforge.recipes.requirements.ExpLevelsRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.ExpPointsRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.HasEnchantmentRequirement;
import com.google.gson.JsonObject;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public interface Requirement {
    public boolean check(class_3222 var1, class_1799 var2);

    public void onFail(class_3222 var1);

    public void onSuccess(class_3222 var1);

    public static Requirement fromJson(JsonObject object) {
        String type = object.get("type").getAsString();
        ConfigHelper.debug("Requirement type is: " + type);
        return switch (type) {
            case "has_exp_points" -> new ExpPointsRequirement(object);
            case "has_exp_levels" -> new ExpLevelsRequirement(object);
            case "has_enchantment" -> new HasEnchantmentRequirement(object);
            default -> throw new IllegalArgumentException("Unknown Requirement type: " + type);
        };
    }

    public static Requirement read(class_2540 buf) {
        String type = buf.method_10800(Short.MAX_VALUE);
        ConfigHelper.debug("Requirement type is: " + type);
        return switch (type) {
            case "has_exp_points" -> ExpPointsRequirement.read(buf);
            case "has_exp_levels" -> ExpLevelsRequirement.read(buf);
            case "has_enchantment" -> HasEnchantmentRequirement.read(buf);
            default -> throw new IllegalArgumentException("Unknown Requirement type: " + type);
        };
    }

    public static void write(class_2540 buf, Requirement requirement) {
        if (requirement instanceof ExpPointsRequirement) {
            buf.method_10814("has_exp_points");
            ExpPointsRequirement.write(buf, (ExpPointsRequirement)requirement);
            return;
        }
        if (requirement instanceof ExpLevelsRequirement) {
            buf.method_10814("has_exp_levels");
            ExpLevelsRequirement.write(buf, (ExpLevelsRequirement)requirement);
            return;
        }
        if (requirement instanceof HasEnchantmentRequirement) {
            buf.method_10814("has_enchantment");
            HasEnchantmentRequirement.write(buf, (HasEnchantmentRequirement)requirement);
            return;
        }
        throw new IllegalArgumentException("Unsupported Requirement impl: " + String.valueOf(requirement.getClass()));
    }
}

