/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.enchantmentforge.screens;

import com.github.spacemex.enchantmentforge.config.ConfigHelper;
import com.github.spacemex.enchantmentforge.forgeregistry.RecipeTypesRegistry;
import com.github.spacemex.enchantmentforge.inventories.ForgeTableInventory;
import com.github.spacemex.enchantmentforge.networking.packets.c2s.OnCraftButtonPressedPacket;
import com.github.spacemex.enchantmentforge.recipes.ForgeRecipe;
import com.github.spacemex.enchantmentforge.recipes.requirements.ExpLevelsRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.ExpPointsRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.HasEnchantmentRequirement;
import com.github.spacemex.enchantmentforge.recipes.requirements.data.Requirement;
import com.github.spacemex.enchantmentforge.screens.handlers.ForgeScreenHandler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_3956;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ForgeScreen
extends class_465<ForgeScreenHandler> {
    private static final class_2960 GUI = class_2960.method_43902((String)"enchantmentforge", (String)"textures/gui/forge_table_gui.png");
    class_4185 craftButton;
    private boolean isFinished = true;
    private boolean animating = false;
    private float arrowR;
    private float arrowL;
    private float arrowM = 0.0f;
    private int rightTick = 15;
    private int leftTick = 15;
    private int middleTick = 15;
    private int animationCounter;
    private int phase;
    private int scrollOffset = 0;
    private final List<class_5481> requirementLines = new ArrayList<class_5481>();
    private final int textBoxWidth = 72;
    private final int textBoxHeight = 110;
    private final int lineHeight = 10;
    private class_1799 hoveredStack = class_1799.field_8037;
    private class_2561 lastFailMsg = null;
    private int lastFailTimer = 0;

    public ForgeScreen(ForgeScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 234;
        this.field_2779 = 166;
    }

    private ForgeScreenHandler getHandler() {
        return (ForgeScreenHandler)this.field_2797;
    }

    protected void method_25426() {
        super.method_25426();
        int x = this.field_2776 + 62;
        int y = this.field_2800 + 53;
        this.craftButton = (class_4185)this.method_37063((class_364)new CraftButtonWidget(x, y, GUI, button -> this.onButtonPress()));
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        this.field_2792 = 253;
        this.renderGui(context);
        this.renderTooltipOverlay(context, mouseX, mouseY);
        this.renderArrows(context);
    }

    protected void method_37432() {
        super.method_37432();
        if (this.lastFailTimer > 0) {
            --this.lastFailTimer;
        }
        this.setToolTipOverlayValues();
        this.syncArrowsFromServerProgress();
    }

    private void syncArrowsFromServerProgress() {
        int serverProgress = this.getHandler().getServerProgress();
        int serverMax = this.getHandler().getServerMaxProgress();
        boolean awaitDrain = ConfigHelper.isAwaitDrain();
        if (serverMax <= 0) {
            this.animating = false;
            this.arrowL = 0.0f;
            this.arrowM = 0.0f;
            this.arrowR = 0.0f;
            this.phase = 0;
            this.animationCounter = 0;
            return;
        }
        this.setArrowTickSpeed();
        int rT = Math.max(1, this.rightTick);
        int mT = Math.max(1, this.middleTick);
        int lT = Math.max(1, this.leftTick);
        int localTotal = rT + mT + lT;
        int p = awaitDrain ? ForgeScreen.mapTriangle(serverProgress, serverMax, localTotal) : ForgeScreen.mapLinear(serverProgress, serverMax, localTotal);
        int segR = Math.min(p, rT);
        int segM = Math.max(0, Math.min(p - rT, mT));
        int segL = Math.max(0, Math.min(p - rT - mT, lT));
        if (p <= rT) {
            this.phase = 0;
            this.animationCounter = segR;
            this.arrowR = (float)segR / (float)rT;
            this.arrowM = 0.0f;
            this.arrowL = 0.0f;
        } else if (p <= rT + mT) {
            this.phase = 1;
            this.animationCounter = segM;
            this.arrowR = 1.0f;
            this.arrowM = (float)segM / (float)mT;
            this.arrowL = 0.0f;
        } else {
            this.phase = 2;
            this.animationCounter = segL;
            this.arrowR = 1.0f;
            this.arrowM = 1.0f;
            this.arrowL = (float)segL / (float)lT;
        }
        this.animating = serverProgress > 0 && serverProgress < serverMax;
        this.isFinished = !this.animating;
    }

    private static int mapLinear(int serverProgress, int serverMax, int localTotal) {
        if (serverMax <= 0) {
            return 0;
        }
        double lin = Math.max(0.0, Math.min(1.0, (double)serverProgress / (double)serverMax));
        return (int)Math.round(lin * (double)localTotal);
    }

    private static int mapTriangle(int serverProgress, int serverMax, int localTotal) {
        if (serverMax <= 0) {
            return 0;
        }
        double half = (double)serverMax / 2.0;
        double tri = (double)serverProgress <= half ? (double)serverProgress : (double)(serverMax - serverProgress);
        tri = Math.max(0.0, Math.min(half, tri));
        double lin = half <= 0.0 ? 0.0 : tri / half;
        return (int)Math.round(lin * (double)localTotal);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
        if (!this.hoveredStack.method_7960()) {
            context.method_51434(this.field_22793, this.hoveredStack.method_7950((class_1657)class_310.method_1551().field_1724, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070)), mouseX, mouseY);
            this.hoveredStack = class_1799.field_8037;
        }
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        context.method_51430(this.field_22793, this.field_22785.method_30937(), this.field_2776 / 2, 6, 0x404040, false);
        context.method_51439(this.field_22793, this.field_29347, this.field_2776 / this.field_25269 + 15, this.field_25270, 0x404040, false);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int maxScroll = Math.max(0, this.requirementLines.size() * 10 - 110);
        this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.scrollOffset - amount * 10.0, (double)maxScroll));
        return true;
    }

    private void setArrowTickSpeed() {
        this.rightTick = ConfigHelper.getRightTick();
        this.leftTick = ConfigHelper.getLeftTick();
        this.middleTick = ConfigHelper.getMiddleTick();
    }

    private void onButtonPress() {
        if (this.animating) {
            return;
        }
        CraftButtonWidget button = (CraftButtonWidget)this.craftButton;
        button.setPressed(true);
        ConfigHelper.debug("Craft Button Pressed, Sending Packet to Server");
        class_2540 buf = new class_2540(Unpooled.buffer());
        NetworkManager.sendToServer((class_2960)OnCraftButtonPressedPacket.ID, (class_2540)buf);
    }

    private void renderGui(class_332 context) {
        int x = this.field_2776;
        int y = this.field_2800;
        context.method_25290(GUI, x, y, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
    }

    private void renderTooltipOverlay(class_332 context, int mouseX, int mouseY) {
        int x = this.field_2776 + 175;
        int y = this.field_2800 + 23;
        int p = 4;
        context.method_25294(x, y, x + 72, y + 110, -2013265920);
        context.method_44379(x, y, x + 72, y + 110);
        int currentY = y - this.scrollOffset;
        if (this.lastFailTimer > 0 && this.lastFailMsg != null && this.isFinished) {
            int avail = 72 - p * 2;
            List lines = this.field_22793.method_1728((class_5348)this.lastFailMsg, avail);
            int lh = this.lineHeight;
            int padV = 2;
            int h = padV * 2 + lines.size() * lh;
            int bgTop = currentY + 2;
            int bgBottom = bgTop + h;
            context.method_25294(x + 2, bgTop, x + 72 - 2, bgBottom, -1437270016);
            int ty = bgTop + padV;
            for (class_5481 line : lines) {
                if (ty + lh >= y && ty <= y + 110) {
                    context.method_51430(this.field_22793, line, x + p, ty, -43691, false);
                }
                ty += lh;
            }
            currentY = bgBottom + 3;
            ConfigHelper.debug("Showing Tooltip Overlay for last fail msg");
        }
        List<Object> reqs = this.getRequirementEntries();
        for (Object entry : reqs) {
            int iconY;
            int iconX;
            if (entry instanceof String) {
                String str = (String)entry;
                for (class_5481 line : this.field_22793.method_1728((class_5348)class_2561.method_43470((String)str), 72 - p * 2)) {
                    if (currentY + 10 >= y && currentY <= y + 110) {
                        context.method_51430(this.field_22793, line, x + p, currentY + 2, 0xFFFFFF, false);
                    }
                    currentY += 10;
                }
                continue;
            }
            if (!(entry instanceof class_1799)) continue;
            class_1799 stack = (class_1799)entry;
            String label = "Enchant:";
            int labelWidth = this.field_22793.method_1727(label);
            int availableWidth = 72 - p * 2;
            if (currentY + 10 >= y && currentY <= y + 110) {
                context.method_51433(this.field_22793, label, x + p, currentY + 4, 0xFFFFFF, false);
            }
            if (labelWidth + 4 + 16 <= availableWidth) {
                iconX = x + p + labelWidth + 4;
                iconY = currentY;
                currentY += 18;
            } else {
                iconX = x + 28;
                iconY = currentY += 10;
                currentY += 18;
            }
            if (iconY + 16 < y || iconY > y + 110) continue;
            context.method_51427(stack, iconX, iconY);
            context.method_51431(this.field_22793, stack, iconX, iconY);
            if (mouseX < iconX || mouseX >= iconX + 16 || mouseY < iconY || mouseY >= iconY + 16) continue;
            this.hoveredStack = stack;
        }
        context.method_44380();
    }

    private void renderArrows(class_332 context) {
        int leftU = 183;
        int LeftV = 228;
        int LeftWidth = 12;
        int LeftHeight = 25;
        int LeftX = this.field_2776 + 50;
        int LeftY = this.field_2800 + 20;
        int rightU = 242;
        int rightV = 228;
        int rightW = 13;
        int rightH = 25;
        int rightX = this.field_2776 + 109;
        int rightY = this.field_2800 + 20;
        int middleU = 212;
        int middleV = 245;
        int middleW = 16;
        int middleH = 11;
        int middleX = this.field_2776 + 79;
        int middleY = this.field_2800 + 37;
        if (this.arrowL > 0.0f) {
            int leftFilled = (int)(this.arrowL * (float)LeftHeight);
            context.method_25290(GUI, LeftX, LeftY + (LeftHeight - leftFilled), (float)leftU, (float)(LeftV + (LeftHeight - leftFilled)), LeftWidth, leftFilled, 256, 256);
        }
        if (this.arrowR > 0.0f) {
            int rightFilled = (int)(this.arrowR * (float)rightH);
            context.method_25290(GUI, rightX, rightY, (float)rightU, (float)rightV, rightW, rightFilled, 256, 256);
        }
        if (this.arrowM > 0.0f) {
            int middleFilled = (int)(this.arrowM * (float)middleW);
            context.method_25290(GUI, middleX + (middleW - middleFilled), middleY, (float)(middleU + (middleW - middleFilled)), (float)middleV, middleFilled, middleH, 256, 256);
        }
    }

    private void setToolTipOverlayValues() {
        List<Object> reqs = this.getRequirementEntries();
        this.requirementLines.clear();
        for (Object entry : reqs) {
            if (!(entry instanceof String)) continue;
            String str = (String)entry;
            this.requirementLines.addAll(this.field_22793.method_1728((class_5348)class_2561.method_43470((String)str), 66));
        }
    }

    private List<Object> getRequirementEntries() {
        ArrayList<Object> entries = new ArrayList<Object>();
        if (!(((ForgeScreenHandler)this.field_2797).getInventory() instanceof ForgeTableInventory)) {
            return entries;
        }
        ForgeTableInventory inventory = ((ForgeScreenHandler)this.field_2797).getInventory();
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return entries;
        }
        Optional match = world.method_8433().method_8132((class_3956)RecipeTypesRegistry.FORGE_TYPE.get(), (class_1263)inventory, (class_1937)world);
        if (match.isEmpty()) {
            return entries;
        }
        ForgeRecipe recipe = (ForgeRecipe)match.get();
        class_1799 gemStack = inventory.method_5438(1);
        if (gemStack.method_7960()) {
            return entries;
        }
        class_2960 gemId = class_7923.field_41178.method_10221((Object)gemStack.method_7909());
        ForgeRecipe.GemEnchantData data = recipe.gemsToEnchantment.get(gemId.toString());
        if (data == null) {
            for (Map.Entry<String, ForgeRecipe.GemEnchantData> entry : recipe.gemsToEnchantment.entrySet()) {
                class_2960 tagId;
                class_6862 tag;
                String key = entry.getKey();
                if (!key.startsWith("#") || !gemStack.method_31573(tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)(tagId = new class_2960(key.substring(1)))))) continue;
                data = entry.getValue();
                break;
            }
        }
        if (data == null) {
            return entries;
        }
        class_1887 ench = (class_1887)class_7923.field_41176.method_10223(data.enchantmentId());
        int currentLevel = class_1890.method_8225((class_1887)ench, (class_1799)inventory.method_5438(0));
        int nextLevel = data.levelMap().stream().filter(l -> l > currentLevel).findFirst().orElse(-1);
        if (nextLevel == -1) {
            return entries;
        }
        int fuelCost = data.costModifierPerLevel().getOrDefault(nextLevel, 0);
        entries.add("Fuel Cost: \u00a76" + fuelCost);
        List reqs = data.requirementsPerLevel().getOrDefault(nextLevel, List.of());
        for (Requirement r : reqs) {
            if (r instanceof ExpPointsRequirement) {
                ExpPointsRequirement epr = (ExpPointsRequirement)r;
                entries.add("Need \u00a7b" + epr.minPoints + "\u00a7r XP points");
            }
            if (r instanceof ExpLevelsRequirement) {
                ExpLevelsRequirement elr = (ExpLevelsRequirement)r;
                entries.add("Need level \u00a7a" + elr.minLevel);
            }
            if (!(r instanceof HasEnchantmentRequirement)) continue;
            HasEnchantmentRequirement her = (HasEnchantmentRequirement)r;
            class_1887 reqEnch = (class_1887)class_7923.field_41176.method_10223(her.enchantId);
            if (reqEnch != null) {
                class_1799 book = new class_1799((class_1935)class_1802.field_8598);
                class_1890.method_8214(Map.of(reqEnch, her.minLevel), (class_1799)book);
                entries.add(book);
                continue;
            }
            entries.add("Requires " + her.enchantId.method_12832() + " lvl " + her.minLevel);
        }
        return entries;
    }

    public void startAnimation() {
        ConfigHelper.debug("Starting Animation");
        this.animating = true;
        this.arrowR = 0.0f;
        this.arrowL = 0.0f;
        this.arrowM = 0.0f;
        this.phase = 0;
        this.animationCounter = 0;
        this.setArrowTickSpeed();
    }

    public void showFailOverlay(class_2561 msg, int ticks) {
        this.lastFailMsg = msg;
        this.lastFailTimer = Math.max(1, ticks);
    }

    private static class CraftButtonWidget
    extends class_344 {
        private boolean pressed = false;
        private final int deselectTicks = 5;
        private long unpressAtTick = -1L;

        public CraftButtonWidget(int x, int y, class_2960 texture, class_4185.class_4241 pressAction) {
            super(x, y, 16, 16, 0, 176, 16, texture, pressAction);
        }

        private static long clientTick() {
            class_310 mc = class_310.method_1551();
            return mc != null && mc.field_1724 != null ? (long)mc.field_1724.field_6012 : 0L;
        }

        public void setPressed(boolean pressed) {
            this.pressed = pressed;
        }

        public void method_25306() {
            super.method_25306();
            this.pressed = true;
            this.unpressAtTick = CraftButtonWidget.clientTick() + 5L;
            ConfigHelper.debug("Craft Button Pressed (hold 5 ticks)");
        }

        public void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
            if (this.pressed && CraftButtonWidget.clientTick() >= this.unpressAtTick) {
                this.pressed = false;
            }
            int vOffset = this.pressed ? this.field_19079 : 0;
            ctx.method_25302(this.field_2127, this.method_46426(), this.method_46427(), this.field_2126, this.field_2125 + vOffset, this.field_22758, this.field_22759);
        }
    }
}

