/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.yml;

import com.github.spacemex.ConfigManager;
import com.github.spacemex.shadow.snakeyaml.Yaml;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;

public class YamlConfigManager
implements ConfigManager {
    private final File configFile;
    private Map<String, Object> data;

    public YamlConfigManager(File file) {
        this.configFile = file;
    }

    @Override
    public void load() {
        try (FileInputStream input = new FileInputStream(this.configFile);){
            this.data = (Map)new Yaml().load(input);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load YAML config", e);
        }
    }

    @Override
    public void save() {
        try (FileWriter writer = new FileWriter(this.configFile);){
            new Yaml().dump(this.data, writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save YAML config", e);
        }
    }
}

