/*
 * Decompiled with CFR 0.152.
 */
package blackwolf00.onepunchman.common;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class OnePunch
extends TieredItem {
    public OnePunch(Tier tier, Item.Properties properties) {
        super(tier, properties.component(DataComponents.TOOL, (Object)OnePunch.createToolProperties()));
    }

    private static Tool createToolProperties() {
        return new Tool(List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f), Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f)), 1.0f, 2);
    }

    public static ItemAttributeModifiers createAttributes(Tier p_336181_, int p_335543_, float p_331072_) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)((float)p_335543_ + p_336181_.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)p_331072_, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    public void postHurtEnemy(ItemStack p_342189_, LivingEntity p_344347_, LivingEntity p_343888_) {
        p_342189_.hurtAndBreak(1, p_343888_, EquipmentSlot.MAINHAND);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        entity.setRemainingFireTicks(1000000);
        return super.onLeftClickEntity(stack, player, entity);
    }

    public InteractionResultHolder use(Level level, Player playerIn, InteractionHand handIn) {
        playerIn.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.HEALTH_BOOST, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.HERO_OF_THE_VILLAGE, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.HEAL, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.JUMP, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.LUCK, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.SATURATION, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1000000, 3));
        playerIn.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1000000, 5));
        playerIn.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 1000000, 5));
        return InteractionResultHolder.pass((Object)playerIn.getItemInHand(handIn));
    }
}

