/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import com.google.common.collect.Lists;
import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.util.DisplayEntryRenderHelper;
import fuzs.pickupnotifier.config.ClientConfig;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;

public abstract class DisplayEntry {
    public static final int ENTRY_HEIGHT = 18;
    private static final int TEXT_ITEM_MARGIN = 4;
    private final Rarity rarity;
    private int remainingTicks;
    private int displayAmount;
    private Component component;

    protected DisplayEntry(int displayAmount, Rarity rarity) {
        this.displayAmount = displayAmount;
        this.rarity = rarity;
        this.resetEntry();
    }

    private static MutableComponent wrapInBrackets(Component toWrap) {
        return Component.literal((String)"(").append(toWrap).append(")");
    }

    public int getDisplayAmount() {
        return this.displayAmount;
    }

    public boolean mayDiscard() {
        return this.remainingTicks <= 0;
    }

    public void tick() {
        if (this.remainingTicks > 0) {
            --this.remainingTicks;
        }
    }

    protected abstract Component getEntryName();

    protected abstract int getInventoryCount(Inventory var1);

    public Component getTextComponent(Player player) {
        if (this.component == null) {
            int displayAmount = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayAmount.isText() ? this.getDisplayAmount() : 0;
            int inventoryCount = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.inventoryCount ? this.getInventoryCount(player.getInventory()) : 0;
            this.component = Component.empty().append(this.createTextComponent(this.getEntryName(), displayAmount, inventoryCount, ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position.mirrored())).setStyle(this.getComponentStyle());
        }
        return this.component;
    }

    private Component createTextComponent(Component name, int displayAmount, int inventoryCount, boolean reverse) {
        ArrayList components = Lists.newArrayList();
        if (inventoryCount > 0) {
            components.add(DisplayEntry.wrapInBrackets((Component)Component.literal((String)String.valueOf(inventoryCount))));
        }
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayItemName) {
            components.add(name);
        }
        if (displayAmount > 1 || displayAmount == 1 && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displaySingleCount) {
            components.add(Component.literal((String)(reverse ? displayAmount + "x" : "x" + displayAmount)));
        }
        if (reverse) {
            Collections.reverse(components);
        }
        return (Component)components.stream().reduce((component1, component2) -> Component.empty().append(component1).append(" ").append(component2)).orElse(Component.empty());
    }

    private Style getComponentStyle() {
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.ignoreRarity && this.rarity != Rarity.COMMON) {
            return ItemHelper.getRarityStyle((Rarity)this.rarity);
        }
        return Style.EMPTY.withColor(((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.textColor);
    }

    public float getRemainingTicksRelative(float partialTicks) {
        float moveTime = Math.min(((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.moveTime, ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime);
        return 1.0f - Mth.clamp((float)(((float)this.remainingTicks - partialTicks) / moveTime), (float)0.0f, (float)1.0f);
    }

    public void resetEntry() {
        this.remainingTicks = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime;
        this.component = null;
    }

    public abstract boolean mayMergeWith(DisplayEntry var1, boolean var2);

    public void mergeWith(DisplayEntry other) {
        this.displayAmount += other.displayAmount;
        this.resetEntry();
    }

    public int getEntryWidth(Minecraft minecraft) {
        int textWidth = minecraft.font.width((FormattedText)this.getTextComponent((Player)minecraft.player));
        return ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.drawSprite ? textWidth + (textWidth == 0 ? 0 : 4) + 16 : textWidth;
    }

    public void render(Minecraft minecraft, GuiGraphics guiGraphics, int posX, int posY, float alpha, float scale) {
        float fadeTime;
        boolean mirrorPosition = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position.mirrored();
        boolean withSprite = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.drawSprite;
        int textStartX = mirrorPosition || !withSprite ? posX : posX + 16 + 4;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        this.renderBg(minecraft, guiGraphics, posX, posY, alpha);
        float f = fadeTime = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.fadeAway ? 1.0f - alpha : 1.0f;
        if (fadeTime * 255.0f >= 5.0f) {
            guiGraphics.drawString(minecraft.font, this.getTextComponent((Player)minecraft.player), textStartX, posY + 4, ARGB.white((float)fadeTime), true);
            if (withSprite) {
                int textWidth = minecraft.font.width((FormattedText)this.getTextComponent((Player)minecraft.player));
                this.renderSprite(minecraft, guiGraphics, mirrorPosition ? posX + textWidth + (textWidth == 0 ? 0 : 4) : posX, posY, scale, fadeTime);
            }
        }
        guiGraphics.pose().popPose();
    }

    private void renderBg(Minecraft minecraft, GuiGraphics guiGraphics, int posX, int posY, float alpha) {
        switch (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.entryBackground) {
            case CHAT: {
                int backgroundOpacity = ARGB.color((int)ARGB.as8BitChannel((float)Mth.clamp((float)(((Double)minecraft.options.textBackgroundOpacity().get()).floatValue() * (1.0f - alpha)), (float)0.0f, (float)1.0f)), (int)0);
                int endY = posY + 16;
                if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayAmount.isSprite()) {
                    ++endY;
                }
                guiGraphics.fill(posX - 3, posY, posX + this.getEntryWidth(minecraft) + 5, endY, backgroundOpacity);
                break;
            }
            case TOOLTIP: {
                DisplayEntryRenderHelper.renderTooltipBackground(guiGraphics, posX, posY + 3, this.getEntryWidth(minecraft), 9, ARGB.white((float)(1.0f - alpha)));
            }
        }
    }

    protected abstract void renderSprite(Minecraft var1, GuiGraphics var2, int var3, int var4, float var5, float var6);
}

