/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.util;

import com.google.common.collect.ImmutableSortedMap;
import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.config.ClientConfig;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class DisplayEntryRenderHelper {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"tooltip/background");
    private static final ResourceLocation FRAME_SPRITE = ResourceLocation.withDefaultNamespace((String)"tooltip/frame");
    private static final NavigableMap<Integer, Character> MAP = ImmutableSortedMap.naturalOrder().put((Object)1000, (Object)Character.valueOf('K')).put((Object)1000000, (Object)Character.valueOf('M')).put((Object)1000000000, (Object)Character.valueOf('B')).build();

    private static MutableComponent shortenValue(int value) {
        Map.Entry<Integer, Character> entry = MAP.floorEntry(value);
        if (entry == null) {
            return Component.literal((String)String.valueOf(value));
        }
        return Component.literal((String)(String.valueOf(value / entry.getKey()) + String.valueOf(entry.getValue())));
    }

    public static void renderGuiItemDecorations(GuiGraphics guiGraphics, Font font, int count, int xPosition, int yPosition) {
        if (count <= 1 && !((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displaySingleCount) {
            return;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0, 0.0, 200.0);
        MutableComponent component = DisplayEntryRenderHelper.shortenValue(count);
        float scale = Math.min(1.0f, 16.0f / (float)font.width((FormattedText)component));
        guiGraphics.pose().scale(scale, scale, 1.0f);
        float posX = (float)(xPosition + 17) / scale - (float)font.width((FormattedText)component);
        Objects.requireNonNull(font);
        float f = (float)(yPosition + 9 * 2) / scale;
        Objects.requireNonNull(font);
        float posY = f - 9.0f;
        guiGraphics.drawSpecial(arg_0 -> DisplayEntryRenderHelper.lambda$renderGuiItemDecorations$0(font, (Component)component, posX, posY, guiGraphics, arg_0));
        guiGraphics.pose().popPose();
    }

    public static void renderTooltipBackground(GuiGraphics guiGraphics, int x, int y, int width, int height, int color) {
        int i = x - 3 - 9;
        int j = y - 3 - 9;
        int k = width + 3 + 3 + 18;
        int l = height + 3 + 3 + 18;
        guiGraphics.pose().pushPose();
        guiGraphics.blitSprite(RenderType::guiTextured, BACKGROUND_SPRITE, i, j, k, l, color);
        guiGraphics.blitSprite(RenderType::guiTextured, FRAME_SPRITE, i, j, k, l, color);
        guiGraphics.pose().popPose();
    }

    private static /* synthetic */ void lambda$renderGuiItemDecorations$0(Font font, Component component, float posX, float posY, GuiGraphics guiGraphics, MultiBufferSource bufferSource) {
        font.drawInBatch(component, posX, posY, -1, true, guiGraphics.pose().last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

