/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import wily.betterfurnaces.util.BFRComponents;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.config.FactoryConfigControl;
import wily.factoryapi.base.config.FactoryConfigDisplay;

public class BFRConfig {
    public static final List<ResourceLocation> supportedLiquidXps = new ArrayList<ResourceLocation>(List.of(FactoryAPI.createLocation((String)"mob_grinding_utils", (String)"fluid_xp"), FactoryAPI.createLocation((String)"industrialforegoing:essence"), FactoryAPI.createLocation((String)"cyclic", (String)"xpjuice"), FactoryAPI.createLocation((String)"reliquary", (String)"xp_juice"), FactoryAPI.createLocation((String)"kibe", (String)"liquid_xp")));
    public static final Codec<List<ResourceLocation>> ID_LIST_CODEC = ResourceLocation.CODEC.listOf();
    public static final FactoryConfig.StorageHandler COMMON_STORAGE = new FactoryConfig.StorageHandler(true);
    public static final FactoryConfigControl.Int TIER_SPEED_CONTROL = new FactoryConfigControl.Int(1, () -> 400, 400);
    public static final FactoryConfig<Boolean> checkUpdates = COMMON_STORAGE.register(FactoryConfig.create((String)"checkUpdates", (FactoryConfigDisplay)FactoryConfigDisplay.createToggle((Component)BFRComponents.optionsName("checkUpdates")), (FactoryConfigControl)FactoryConfigControl.TOGGLE, (Object)true, b -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Integer> cacheCapacity = COMMON_STORAGE.register(FactoryConfig.create((String)"cacheCapacity", BFRConfig.createSliderDisplay("cacheCapacity"), (FactoryConfigControl)new FactoryConfigControl.Int(1, () -> 100, 100), (Object)10, v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Integer> furnaceXPDropValue = COMMON_STORAGE.register(FactoryConfig.create((String)"experienceDropValue", BFRConfig.createSliderDisplay("experienceDropValue"), (FactoryConfigControl)new FactoryConfigControl.Int(1, () -> 500, 500), (Object)1, v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Integer> furnaceAccumulatedXPDropValue = COMMON_STORAGE.register(FactoryConfig.create((String)"accumulatedExperienceDropValue", BFRConfig.createSliderDisplay("accumulatedExperienceDropValue"), (FactoryConfigControl)new FactoryConfigControl.Int(1, () -> 1000000, 1000000), (Object)10000, v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Boolean> checkCommonOresName = COMMON_STORAGE.register(FactoryConfig.create((String)"checkCommonOresName", (FactoryConfigDisplay)FactoryConfigDisplay.createToggle((Component)BFRComponents.optionsName("checkCommonOresName")), (FactoryConfigControl)FactoryConfigControl.TOGGLE, (Object)false, b -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Boolean> checkRawOresName = COMMON_STORAGE.register(FactoryConfig.create((String)"checkRawOresName", (FactoryConfigDisplay)FactoryConfigDisplay.createToggle((Component)BFRComponents.optionsName("checkRawOresName")), (FactoryConfigControl)FactoryConfigControl.TOGGLE, (Object)false, b -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Integer> copperTierSpeed = COMMON_STORAGE.register(FactoryConfig.create((String)"copperTierSpeed", BFRConfig.createSliderDisplay("copperTierSpeed"), (FactoryConfigControl)TIER_SPEED_CONTROL, (Object)175, v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Integer> ironTierSpeed = COMMON_STORAGE.register(FactoryConfig.create((String)"ironTierSpeed", BFRConfig.createSliderDisplay("ironTierSpeed"), (FactoryConfigControl)TIER_SPEED_CONTROL, (Object)150, v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Integer> steelTierSpeed = COMMON_STORAGE.register(FactoryConfig.create((String)"steelTierSpeed", BFRConfig.createSliderDisplay("steelTierSpeed"), (FactoryConfigControl)TIER_SPEED_CONTROL, (Object)125, v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Integer> goldTierSpeed = COMMON_STORAGE.register(FactoryConfig.create((String)"goldTierSpeed", BFRConfig.createSliderDisplay("goldTierSpeed"), (FactoryConfigControl)TIER_SPEED_CONTROL, (Object)100, v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Integer> amethystTierSpeed = COMMON_STORAGE.register(FactoryConfig.create((String)"amethystTierSpeed", BFRConfig.createSliderDisplay("amethystTierSpeed"), (FactoryConfigControl)TIER_SPEED_CONTROL, (Object)75, v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Integer> diamondTierSpeed = COMMON_STORAGE.register(FactoryConfig.create((String)"diamondTierSpeed", BFRConfig.createSliderDisplay("diamondTierSpeed"), (FactoryConfigControl)TIER_SPEED_CONTROL, (Object)50, v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Integer> platinumTierSpeed = COMMON_STORAGE.register(FactoryConfig.create((String)"platinumTierSpeed", BFRConfig.createSliderDisplay("platinumTierSpeed"), (FactoryConfigControl)TIER_SPEED_CONTROL, (Object)25, v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Integer> netherhotTierSpeed = COMMON_STORAGE.register(FactoryConfig.create((String)"netherhotTierSpeed", BFRConfig.createSliderDisplay("netherhotTierSpeed"), (FactoryConfigControl)TIER_SPEED_CONTROL, (Object)8, v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Integer> extremeTierSpeed = COMMON_STORAGE.register(FactoryConfig.create((String)"extremeTierSpeed", BFRConfig.createSliderDisplay("extremeTierSpeed"), (FactoryConfigControl)TIER_SPEED_CONTROL, (Object)4, v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<Integer> ultimateTierSpeed = COMMON_STORAGE.register(FactoryConfig.create((String)"ultimateTierSpeed", BFRConfig.createSliderDisplay("ultimateTierSpeed"), (FactoryConfigControl)TIER_SPEED_CONTROL, (Object)1, v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<ResourceLocation> xpFluidType = COMMON_STORAGE.register(FactoryConfig.create((String)"experienceFluidType", BFRConfig.createCyclingDisplay("experienceFluidType"), (FactoryConfigControl)new FactoryConfigControl.FromInt(supportedLiquidXps::get, supportedLiquidXps::indexOf, supportedLiquidXps::size), (Object)supportedLiquidXps.get(0), v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));
    public static final FactoryConfig<List<ResourceLocation>> additionalLiquidFuels = COMMON_STORAGE.register(FactoryConfig.create((String)"additionalLiquidFuels", null, () -> ID_LIST_CODEC, Collections.emptyList(), v -> {}, (FactoryConfig.StorageAccess)COMMON_STORAGE));

    public static ResourceLocation getLiquidXPType() {
        return (ResourceLocation)xpFluidType.get();
    }

    public static Fluid getLiquidXP() {
        return (Fluid)FactoryAPIPlatform.getRegistryValue((ResourceLocation)BFRConfig.getLiquidXPType(), (Registry)BuiltInRegistries.FLUID);
    }

    public static String getLiquidXPMod() {
        return BFRConfig.getLiquidXPType().getNamespace();
    }

    public static <T> FactoryConfigDisplay<T> createSliderDisplay(String id) {
        return new FactoryConfigDisplay.Instance(BFRComponents.optionsName(id), (c, v) -> Component.translatable((String)"options.generic_value", (Object[])new Object[]{c, v.toString()}));
    }

    public static <T> FactoryConfigDisplay<T> createCyclingDisplay(String id) {
        return new FactoryConfigDisplay.Instance(BFRComponents.optionsName(id), (c, v) -> Component.literal((String)v.toString()));
    }
}

