/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces;

import java.util.List;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import wily.betterfurnaces.BetterFurnacesReforged;
import wily.betterfurnaces.blocks.SmeltingBlock;
import wily.betterfurnaces.client.BFRClientConfig;
import wily.betterfurnaces.client.renderer.ForgeRenderer;
import wily.betterfurnaces.client.renderer.FurnaceRenderer;
import wily.betterfurnaces.client.screen.BFRConfigScreen;
import wily.betterfurnaces.client.screen.CobblestoneGeneratorScreen;
import wily.betterfurnaces.client.screen.ColorUpgradeScreen;
import wily.betterfurnaces.client.screen.ForgeScreen;
import wily.betterfurnaces.client.screen.FuelVerifierScreen;
import wily.betterfurnaces.client.screen.FurnaceScreen;
import wily.betterfurnaces.gitup.UpCheck;
import wily.betterfurnaces.init.BlockEntityTypes;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.init.Registration;
import wily.betterfurnaces.items.ColorUpgradeItem;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.util.ModInfo;

public class BetterFurnacesReforgedClient {
    public static void init() {
        FactoryAPIClient.setup(m -> {
            BFRClientConfig.CLIENT_STORAGE.load();
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityTypes.BETTER_FURNACE_TILE.get()), FurnaceRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityTypes.FORGE_TILE.get()), ForgeRenderer::new);
        });
        Registration.getSmeltingBlocks().forEach(block -> {
            FactoryAPIClient.setup(m -> ItemProperties.register((Item)((Block)block.get()).asItem(), (ResourceLocation)BetterFurnacesReforged.createModLocation("colored"), (stack, level, living, id) -> ColorUpgradeItem.itemContainsColor(stack) ? 1.0f : 0.0f));
            FactoryAPIClient.registerItemColor(r -> r.accept(BetterFurnacesReforgedClient::getFurnaceColor, ((Block)block.get()).asItem()));
        });
        FactoryAPIClient.registerMenuScreen(menuScreenRegister -> {
            menuScreenRegister.register((MenuType)ModObjects.FURNACE_CONTAINER.get(), FurnaceScreen::new);
            menuScreenRegister.register((MenuType)ModObjects.FORGE_CONTAINER.get(), ForgeScreen::new);
            menuScreenRegister.register((MenuType)ModObjects.COLOR_UPGRADE_CONTAINER.get(), ColorUpgradeScreen::new);
            menuScreenRegister.register((MenuType)ModObjects.FUEL_VERIFIER_CONTAINER.get(), FuelVerifierScreen::new);
            menuScreenRegister.register((MenuType)ModObjects.COB_GENERATOR_CONTAINER.get(), CobblestoneGeneratorScreen::new);
        });
        FactoryAPIClient.registerConfigScreen((ModInfo)FactoryAPIPlatform.getModInfo((String)"betterfurnacesreforged"), BFRConfigScreen::new);
        FactoryAPIClient.PlayerEvent.JOIN_EVENT.register(localPlayer -> {
            if (UpCheck.checkFailed) {
                localPlayer.displayClientMessage((Component)Component.Serializer.fromJson((String)I18n.get((String)"betterfurnacesreforged.update.failed", (Object[])new Object[0]), (HolderLookup.Provider)localPlayer.registryAccess()), false);
                UpCheck.checkFailed = false;
            } else if (UpCheck.needsUpdateNotify) {
                localPlayer.displayClientMessage((Component)Component.Serializer.fromJson((String)I18n.get((String)"betterfurnacesreforged.update.speech", (Object[])new Object[0]), (HolderLookup.Provider)localPlayer.registryAccess()), false);
                localPlayer.displayClientMessage((Component)Component.Serializer.fromJson((String)I18n.get((String)"betterfurnacesreforged.update.version", (Object[])new Object[]{"1.20.4-" + BetterFurnacesReforged.VERSION.get(), UpCheck.updateVersionString}), (HolderLookup.Provider)localPlayer.registryAccess()), false);
                localPlayer.displayClientMessage((Component)Component.Serializer.fromJson((String)I18n.get((String)"betterfurnacesreforged.update.buttons", (Object[])new Object[]{"https://www.curseforge.com/minecraft/mc-mods/better-furnaces-reforged/"}), (HolderLookup.Provider)localPlayer.registryAccess()), false);
                UpCheck.needsUpdateNotify = false;
            }
        });
        FactoryAPIClient.registerExtraModels(register -> {
            SmeltingBlock.TYPE.getPossibleValues().forEach(i -> List.of(Boolean.valueOf(false), Boolean.valueOf(true)).forEach(b -> register.accept(FurnaceRenderer.getFront(i, b))));
            register.accept(BetterFurnacesReforged.createModLocation("colored_furnace"));
            register.accept(BetterFurnacesReforged.createModLocation("colored_forge"));
            register.accept(BetterFurnacesReforged.createModLocation("colored_forge_on"));
            register.accept(BetterFurnacesReforged.createModLocation("nsweud"));
        });
        FactoryEvent.registerBuiltInPacks(registry -> registry.register("programmer_art", FactoryAPI.createLocation((String)"betterfurnacesreforged", (String)"programmer_art"), (Component)Component.translatable((String)"builtin.betterfurnacesreforged.programmer_art"), Pack.Position.TOP, false));
    }

    public static int getFurnaceColor(ItemStack stack, int tint) {
        return ((ModObjects.BlockTint)stack.getOrDefault((DataComponentType)ModObjects.BLOCK_TINT.get(), (Object)ModObjects.BlockTint.WHITE)).toRGB();
    }
}

