/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blockentity;

import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import wily.betterfurnaces.init.ModObjects;

public interface FactoryUpgradeSettings {
    public static FactoryUpgradeSettings of(ItemStack stack) {
        return () -> stack;
    }

    public ItemStack getContainer();

    public static boolean containsSettings(ItemStack container) {
        for (Type type : Type.values()) {
            if (FactoryUpgradeSettings.containsSetting(type, container)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsSetting(Type type, ItemStack container) {
        return container.has((DataComponentType)ModObjects.getSettingComponent(type).get());
    }

    default public void putBlankSettings() {
        if (!FactoryUpgradeSettings.containsSettings(this.getContainer())) {
            for (Type value : Type.values()) {
                this.setFurnaceSetting(value, value == Type.SIDES ? FactoryUpgradeSettings.getDefaultSides() : value.emptySetting());
            }
        }
    }

    default public int get(Type type, int index) {
        if (this.getContainer().isEmpty() || !FactoryUpgradeSettings.containsSetting(type, this.getContainer())) {
            return 0;
        }
        return this.getFurnaceSetting(type)[index];
    }

    default public int getSides(int index) {
        return this.get(Type.SIDES, index);
    }

    default public int getAutoIO(int index) {
        return this.get(Type.AUTO_IO, index);
    }

    default public int getRedstone(int index) {
        return this.get(Type.REDSTONE, index);
    }

    default public void set(Type type, int index, int value) {
        if (this.getContainer().isEmpty()) {
            return;
        }
        int[] settings = (int[])this.getFurnaceSetting(type).clone();
        settings[index] = value;
        this.setFurnaceSetting(type, settings);
        this.onChanged();
    }

    default public int size() {
        if (this.getContainer().isEmpty()) {
            return 0;
        }
        int size = 0;
        for (Type value : Type.values()) {
            size += value.size;
        }
        return size;
    }

    default public int[] getFurnaceSetting(Type type) {
        if (!FactoryUpgradeSettings.containsSetting(type, this.getContainer())) {
            return new int[type.size];
        }
        return ((ModObjects.UpgradeSetting)this.getContainer().get((DataComponentType)ModObjects.getSettingComponent(type).get())).values();
    }

    default public void setFurnaceSetting(Type type, int[] settings) {
        this.getContainer().set((DataComponentType)ModObjects.getSettingComponent(type).get(), (Object)new ModObjects.UpgradeSetting(settings));
    }

    default public void onChanged() {
    }

    public static int[] getDefaultSides() {
        int[] sides = Type.SIDES.emptySetting();
        for (Direction dir : Direction.values()) {
            sides[dir.ordinal()] = 4;
        }
        sides[0] = 2;
        sides[1] = 1;
        return sides;
    }

    public static enum Type {
        SIDES("Settings", 6),
        AUTO_IO("AutoIO", 2),
        REDSTONE("Redstone", 2);

        public final String id;
        public final int size;

        private Type(String id, int size) {
            this.id = id;
            this.size = size;
        }

        public int[] emptySetting() {
            return new int[this.size];
        }
    }
}

