/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.init.BlockEntityTypes;
import wily.betterfurnaces.inventory.ForgeMenu;
import wily.betterfurnaces.inventory.SlotFuel;
import wily.betterfurnaces.inventory.SlotHeater;
import wily.betterfurnaces.inventory.SlotInput;
import wily.betterfurnaces.inventory.SlotOutput;
import wily.betterfurnaces.inventory.SlotUpgrade;
import wily.factoryapi.base.BlockSide;
import wily.factoryapi.base.FactoryItemSlot;

public class ForgeBlockEntity
extends SmeltingBlockEntity {
    public static final BlockSide[] FORGE_TOP_FACE_SIDES = new BlockSide[]{BlockSide.TOP, BlockSide.BOTTOM, BlockSide.BACK, BlockSide.FRONT, BlockSide.RIGHT, BlockSide.LEFT};

    @Override
    public int[] getFuelIndexes() {
        return new int[]{3};
    }

    @Override
    public int getHeaterIndex() {
        return 10;
    }

    @Override
    public int[] getUpgradeIndexes() {
        return new int[]{7, 8, 9, 10, 11, 12, 13};
    }

    @Override
    public int[] getInputs() {
        return new int[]{0, 1, 2};
    }

    @Override
    public int[] getOutputs() {
        return new int[]{4, 5, 6};
    }

    @Override
    public int getLiquidCapacity() {
        return 2 * super.getLiquidCapacity();
    }

    @Override
    public int getEnergyCapacity() {
        return 64000;
    }

    @Override
    protected BlockSide[] getSidesOrder() {
        return FORGE_TOP_FACE_SIDES;
    }

    public ForgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.FORGE_TILE.get(), pos, state);
    }

    @Override
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory) {
        return new ForgeMenu(i, this.level, this.getBlockPos(), playerInventory, this.fields);
    }

    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    @Override
    public void addSlots(NonNullList<FactoryItemSlot> slots, @Nullable Player player) {
        int y1 = 62;
        int y2 = 100;
        int y3 = 80;
        int y4 = 5;
        slots.add((Object)new SlotInput(this, 0, 27, y1));
        slots.add((Object)new SlotInput(this, 1, 45, y1));
        slots.add((Object)new SlotInput(this, 2, 63, y1));
        slots.add((Object)new SlotFuel(this, 3, 8, y2));
        slots.add((Object)new SlotOutput(player, this, 4, 108, y3));
        slots.add((Object)new SlotOutput(player, this, 5, 126, y3));
        slots.add((Object)new SlotOutput(player, this, 6, 144, y3));
        slots.add((Object)new SlotUpgrade(this, 7, 7, y4));
        slots.add((Object)new SlotUpgrade(this, 8, 25, y4));
        slots.add((Object)new SlotUpgrade(this, 9, 43, y4));
        slots.add((Object)new SlotHeater(this, 10, 79, y4));
        slots.add((Object)new SlotUpgrade(this, 11, 115, y4));
        slots.add((Object)new SlotUpgrade(this, 12, 133, y4));
        slots.add((Object)new SlotUpgrade(this, 13, 151, y4));
    }
}

